/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IItemHudInfo;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.item.IHandHeldInventory;
import ic2.core.util.LiquidUtil;
import ic2.core.util.StackUtil;
import ihl.IHLCreativeTab;
import ihl.processing.metallurgy.CrucibleInventory;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class Crucible
extends Item
implements IHandHeldInventory,
IFluidContainerItem,
IItemHudInfo {
    public int capacity = 864;
    private String itemName = "crucible";
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager("crucible");
    @SideOnly(value=Side.CLIENT)
    private IIcon iconHot;

    public Crucible() {
        this.func_77655_b(this.itemName);
        GameRegistry.registerItem((Item)this, (String)this.itemName);
        this.func_77637_a(IHLCreativeTab.tab);
        this.field_77777_bU = 1;
        this.func_77637_a(IHLCreativeTab.tab);
        this.func_77656_e(0);
    }

    public static void addRecipe(String string, FluidStack output) {
        recipeManager.addRecipe(new UniversalRecipeInput(null, new IRecipeInput[]{new RecipeInputOreDict(string)}), new UniversalRecipeOutput(new FluidStack[]{output}, null, 20));
    }

    public IHasGui getInventory(EntityPlayer entityPlayer, ItemStack itemStack) {
        return new CrucibleInventory(entityPlayer, itemStack);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (IC2.platform.isSimulating()) {
            IC2.platform.launchGui(entityPlayer, this.getInventory(entityPlayer, itemStack));
        }
        return itemStack;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        super.func_77624_a(itemStack, player, info, b);
        FluidStack fs = this.getFluid(itemStack);
        if (fs != null) {
            info.add("< " + FluidRegistry.getFluidName((FluidStack)fs) + ", " + fs.amount + " mB >");
        } else {
            info.add(StatCollector.func_74838_a((String)"ic2.item.FluidContainer.Empty"));
        }
    }

    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        FluidStack fs = this.getFluid(itemStack);
        if (fs != null) {
            info.add("< " + FluidRegistry.getFluidName((FluidStack)fs) + ", " + fs.amount + " mB >");
        } else {
            info.add(StatCollector.func_74838_a((String)"ic2.item.FluidContainer.Empty"));
        }
        return info;
    }

    public FluidStack getFluid(ItemStack stack) {
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData((ItemStack)stack);
        NBTTagCompound fluidTag = nbtTagCompound.func_74775_l("Fluid");
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
    }

    public boolean isEmpty(ItemStack stack) {
        return this.getFluid(stack) == null;
    }

    public int getCapacity(ItemStack container) {
        return this.capacity;
    }

    public boolean canfill(Fluid var1) {
        return true;
    }

    public ItemStack processContent(ItemStack itemStack, IInventory inventoryContainer) {
        UniversalRecipeOutput routput;
        CrucibleInventory inventory = new CrucibleInventory(inventoryContainer, itemStack);
        ItemStack content = inventory.func_70301_a(0);
        if (content != null && (routput = recipeManager.getOutputFor(null, Arrays.asList(content))) != null && !routput.getFluidOutputs().isEmpty()) {
            FluidStack fluidStack = routput.getFluidOutputs().get(0).copy();
            fluidStack.amount *= content.field_77994_a;
            itemStack.field_77990_d = new NBTTagCompound();
            this.fill(itemStack, fluidStack, true);
            return itemStack;
        }
        return itemStack;
    }

    public int fill(ItemStack stack, FluidStack resource, boolean doFill) {
        if (stack.field_77994_a != 1) {
            return 0;
        }
        if (resource == null) {
            return 0;
        }
        if (!this.canfill(resource.getFluid())) {
            return 0;
        }
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData((ItemStack)stack);
        NBTTagCompound fluidTag = nbtTagCompound.func_74775_l("Fluid");
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (fs == null) {
            fs = new FluidStack(resource, 0);
        }
        if (!fs.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(this.capacity - fs.amount, resource.amount);
        if (doFill && amount > 0) {
            fs.amount += amount;
            fs.writeToNBT(fluidTag);
            nbtTagCompound.func_74782_a("Fluid", (NBTBase)fluidTag);
            if (fs.getFluid().getTemperature() > 900) {
                stack.func_77964_b(1);
            }
        }
        return amount;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        if (stack.field_77994_a != 1) {
            return null;
        }
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData((ItemStack)stack);
        NBTTagCompound fluidTag = nbtTagCompound.func_74775_l("Fluid");
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (fs == null) {
            return null;
        }
        maxDrain = Math.min(fs.amount, maxDrain);
        if (doDrain) {
            fs.amount -= maxDrain;
            if (fs.amount <= 0) {
                nbtTagCompound.func_82580_o("Fluid");
                stack.func_77964_b(0);
            } else {
                fs.writeToNBT(fluidTag);
                nbtTagCompound.func_74782_a("Fluid", (NBTBase)fluidTag);
            }
        }
        return new FluidStack(fs, maxDrain);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("ihl:crucible");
        this.iconHot = register.func_94245_a("ihl:crucibleHot");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        switch (meta) {
            case 0: {
                return this.field_77791_bV;
            }
            case 1: {
                return this.iconHot;
            }
        }
        return this.field_77791_bV;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        return this.interactWithTank(stack, player, world, x, y, z, side);
    }

    private boolean interactWithTank(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)te;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        FluidStack fs = this.getFluid(stack);
        if (!(fs == null || player.func_70093_af() && fs.amount < this.capacity)) {
            int amount = handler.fill(dir, fs, false);
            if (amount <= 0) {
                return false;
            }
            fs = LiquidUtil.drainContainerStack((ItemStack)stack, (EntityPlayer)player, (int)amount, (boolean)false);
            if (fs != null && fs.amount > 0) {
                handler.fill(dir, fs, true);
                return true;
            }
            return false;
        }
        int amount = fs == null ? this.capacity : this.capacity - fs.amount;
        FluidStack input = handler.drain(dir, amount, false);
        if (input != null && input.amount > 0) {
            amount = LiquidUtil.fillContainerStack((ItemStack)stack, (EntityPlayer)player, (FluidStack)input, (boolean)false);
            if (amount <= 0) {
                return false;
            }
            handler.drain(dir, amount, true);
            return true;
        }
        return false;
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }
}

