/*
 * Decompiled with CFR 0.152.
 */
package ihl.collector;

import ihl.IHLMod;
import ihl.collector.CollectorEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class CollectorHeavyEntity
extends CollectorEntity {
    private ItemStack capturedStack2;
    private ItemStack capturedStack3;
    private ItemStack capturedStack4;

    public CollectorHeavyEntity(World par1World) {
        super(par1World);
        this.setSize(0.98f, 0.25f);
        this.energyConsume = 4;
        this.thisItem = IHLMod.collectorHeavyItem;
        this.waypointX = this.posX;
        this.waypointY = this.posY;
        this.waypointZ = this.posZ;
        this.lastItemX = this.posX;
        this.lastItemY = this.posY;
        this.lastItemZ = this.posZ;
    }

    public CollectorHeavyEntity(World par1World, double par2, double par4, double par6) {
        this(par1World);
        this.setPosition(par2, par4, par6);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = par2;
        this.prevPosY = par4;
        this.prevPosZ = par6;
        this.lastItemX = this.posX;
        this.lastItemY = this.posY;
        this.lastItemZ = this.posZ;
        this.energyConsume = 4;
        this.thisItem = IHLMod.collectorHeavyItem;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.func_82709_a(19, 5);
        this.dataWatcher.func_82709_a(20, 5);
        this.dataWatcher.func_82709_a(21, 5);
    }

    protected void dropItem() {
        double var5;
        double var3;
        double var1;
        double var7;
        if (this.hopper != null && (var7 = (var1 = (double)this.hopper.field_145851_c - this.posX) * var1 + (var3 = (double)this.hopper.field_145848_d - this.posY + 2.0) * var3 + (var5 = (double)this.hopper.field_145849_e - this.posZ) * var5) < 2.0) {
            for (int i = 0; i < 4; ++i) {
                if (this.getItemStackNum(i) == null || !this.addItemStackToInventory((IInventory)this.hopper, this.getItemStackNum(i))) continue;
                this.setItemStackSlotContent(i, null);
            }
        }
    }

    public ItemStack getVisibleItemStack(int num) {
        return this.dataWatcher.func_82710_f(18 + num);
    }

    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        try {
            NBTTagList var2 = nbt.func_150295_c("Items", 10);
            if (var2 != null) {
                for (int i = 1; i < 4; ++i) {
                    NBTTagCompound var4 = var2.func_150305_b(i);
                    if (var4 == null) continue;
                    this.setItemStackSlotContent(i, ItemStack.func_77949_a((NBTTagCompound)var4));
                    if (this.getItemStackNum(i) == null) continue;
                    this.dataWatcher.func_75692_b(18 + i, (Object)this.getItemStackNum(i).func_77946_l());
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        try {
            NBTTagList var2 = nbt.func_150295_c("Items", 10);
            if (var2 != null) {
                for (int i = 1; i < 4; ++i) {
                    if (this.getItemStackNum(i) == null) continue;
                    NBTTagCompound var4 = new NBTTagCompound();
                    var4.func_74774_a("Slot", (byte)i);
                    this.getItemStackNum(i).func_77955_b(var4);
                    var2.func_74742_a((NBTBase)var4);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void spawnContainedItems() {
        if (this.capturedStack != null) {
            this.worldObj.func_72838_d((Entity)new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, this.capturedStack));
        }
        if (this.capturedStack2 != null) {
            this.worldObj.func_72838_d((Entity)new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, this.capturedStack2));
        }
        if (this.capturedStack3 != null) {
            this.worldObj.func_72838_d((Entity)new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, this.capturedStack3));
        }
        if (this.capturedStack4 != null) {
            this.worldObj.func_72838_d((Entity)new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, this.capturedStack4));
        }
    }

    private ItemStack getItemStackNum(int num) {
        switch (num) {
            case 0: {
                return this.capturedStack;
            }
            case 1: {
                return this.capturedStack2;
            }
            case 2: {
                return this.capturedStack3;
            }
            case 3: {
                return this.capturedStack4;
            }
        }
        return this.capturedStack;
    }

    private void setItemStackSlotContent(int num, ItemStack itemStack) {
        switch (num) {
            case 0: {
                this.capturedStack = itemStack;
                if (this.capturedStack != null) {
                    this.dataWatcher.func_75692_b(18, (Object)this.capturedStack.func_77946_l());
                    break;
                }
                this.dataWatcher.func_75692_b(18, (Object)this.capturedStack);
                break;
            }
            case 1: {
                this.capturedStack2 = itemStack;
                if (this.capturedStack2 != null) {
                    this.dataWatcher.func_75692_b(19, (Object)this.capturedStack2.func_77946_l());
                    break;
                }
                this.dataWatcher.func_75692_b(19, (Object)this.capturedStack2);
                break;
            }
            case 2: {
                this.capturedStack3 = itemStack;
                if (this.capturedStack3 != null) {
                    this.dataWatcher.func_75692_b(20, (Object)this.capturedStack3.func_77946_l());
                    break;
                }
                this.dataWatcher.func_75692_b(20, (Object)this.capturedStack3);
                break;
            }
            case 3: {
                this.capturedStack4 = itemStack;
                if (this.capturedStack4 != null) {
                    this.dataWatcher.func_75692_b(21, (Object)this.capturedStack4.func_77946_l());
                    break;
                }
                this.dataWatcher.func_75692_b(21, (Object)this.capturedStack4);
                break;
            }
        }
    }

    private void addItemStackSlotContent(int num, ItemStack itemStack) {
        switch (num) {
            case 0: {
                this.capturedStack.field_77994_a += itemStack.field_77994_a;
                break;
            }
            case 1: {
                this.capturedStack2.field_77994_a += itemStack.field_77994_a;
                break;
            }
            case 2: {
                this.capturedStack3.field_77994_a += itemStack.field_77994_a;
                break;
            }
            case 3: {
                this.capturedStack4.field_77994_a += itemStack.field_77994_a;
                break;
            }
        }
    }

    protected boolean canAdd(ItemStack stack) {
        for (int i = 0; i < 4; ++i) {
            if (this.getItemStackNum(i) == null) {
                return true;
            }
            if (this.getItemStackNum((int)i).field_77994_a >= this.getItemStackNum(i).func_77976_d() || this.getItemStackNum(i).func_77973_b() != stack.func_77973_b() || this.getItemStackNum(i).func_77960_j() != stack.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    protected void harvest(EntityItem eItem) {
        for (int i = 0; i < 4; ++i) {
            if (this.getItemStackNum(i) == null) {
                this.setItemStackSlotContent(i, eItem.func_92059_d());
                if (!this.worldObj.field_72995_K) {
                    eItem.func_70106_y();
                }
                this.target = null;
                if (this.capturedStack != null) {
                    this.dataWatcher.func_75692_b(18 + i, (Object)this.getItemStackNum(i).func_77946_l());
                    this.lastItemX = this.posX;
                    this.lastItemY = this.posY;
                    this.lastItemZ = this.posZ;
                }
                return;
            }
            if (this.getItemStackNum(i).func_77973_b() != eItem.func_92059_d().func_77973_b() || this.getItemStackNum(i).func_77960_j() != eItem.func_92059_d().func_77960_j()) continue;
            this.addItemStackSlotContent(i, eItem.func_92059_d());
            if (!this.worldObj.field_72995_K) {
                eItem.func_70106_y();
            }
            this.target = null;
            this.dataWatcher.func_75692_b(18 + i, (Object)this.getItemStackNum(i).func_77946_l());
            this.lastItemX = this.posX;
            this.lastItemY = this.posY;
            this.lastItemZ = this.posZ;
            return;
        }
    }
}

