/*
 * Decompiled with CFR 0.152.
 */
package ihl.enviroment;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import ihl.ClientProxy;
import ihl.IHLMod;
import ihl.enviroment.LightBulbTileEntity;
import ihl.enviroment.LightSource;
import ihl.utils.IHLUtils;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class SpotlightTileEntity
extends LightBulbTileEntity
implements INetworkTileEntityEventListener {
    public float directionX = 0.0f;
    public float directionY = -1.0f;
    public float directionZ = 0.0f;
    public float prevDirectionX = 0.0f;
    public float prevDirectionY = -1.0f;
    public float prevDirectionZ = 0.0f;
    public float rotationPitch = 0.0f;
    public float rotationYaw = 0.0f;
    public float prevRotationPitch = 0.0f;
    public float prevRotationYaw = 0.0f;
    boolean needLightTargetUpdate = false;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.directionX = nbttagcompound.func_74760_g("directionX");
        this.directionY = nbttagcompound.func_74760_g("directionY");
        this.directionZ = nbttagcompound.func_74760_g("directionZ");
        this.rotationPitch = this.getVectorPitchAngle(this.directionX, this.directionY, this.directionZ);
        this.rotationYaw = this.getVectorYawAngle(this.directionX, this.directionY, this.directionZ);
        this.needLightTargetUpdate = true;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("directionX", (double)this.directionX);
        nbttagcompound.func_74780_a("directionY", (double)this.directionY);
        nbttagcompound.func_74780_a("directionZ", (double)this.directionZ);
    }

    @Override
    public List<String> getNetworkedFields() {
        List<String> list = super.getNetworkedFields();
        list.add("needLightTargetUpdate");
        list.add("rotationPitch");
        list.add("rotationYaw");
        list.add("directionX");
        list.add("directionY");
        list.add("directionZ");
        return list;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.directionX != this.prevDirectionX || this.directionY != this.prevDirectionY || this.directionZ != this.prevDirectionZ) {
                this.updateLightState();
                this.prevDirectionX = this.directionX;
                this.prevDirectionY = this.directionY;
                this.prevDirectionZ = this.directionZ;
            }
        } else if (this.needLightTargetUpdate) {
            this.updateLightState();
            this.needLightTargetUpdate = false;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.prevRotationPitch != this.rotationPitch) {
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "rotationPitch");
                this.prevRotationPitch = this.rotationPitch;
            }
            if (this.prevRotationYaw != this.rotationYaw) {
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "rotationYaw");
                this.prevRotationYaw = this.rotationYaw;
            }
        }
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("spotlight");
    }

    public void setDirectionVector(EntityLivingBase player) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
        Vec3 lookVec = player.func_70040_Z();
        if (lookVec.field_72450_a * (double)dir.offsetX + lookVec.field_72448_b * (double)dir.offsetY + lookVec.field_72449_c * (double)dir.offsetZ < 0.0) {
            double x = player.field_70165_t - (double)this.field_145851_c - 0.5;
            double y = player.field_70163_u + (double)player.func_70047_e() - (double)this.field_145848_d - 0.5;
            double z = player.field_70161_v - (double)this.field_145849_e - 0.5;
            double d = Math.sqrt(x * x + y * y + z * z);
            this.directionX = (float)(x / d);
            this.directionY = (float)(y / d);
            this.directionZ = (float)(z / d);
        } else {
            Vec3 plook = player.func_70040_Z();
            this.directionX = (float)plook.field_72450_a;
            this.directionY = (float)plook.field_72448_b;
            this.directionZ = (float)plook.field_72449_c;
        }
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "directionX");
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "directionY");
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "directionZ");
        this.rotationPitch = this.getVectorPitchAngle(this.directionX, this.directionY, this.directionZ);
        this.rotationYaw = this.getVectorYawAngle(this.directionX, this.directionY, this.directionZ);
        this.needLightTargetUpdate = true;
        ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
    }

    private float getVectorPitchAngle(float x, float y, float z) {
        switch (this.getFacing()) {
            case 0: {
                return (float)(-(Math.abs(Math.asin(z)) + Math.abs(Math.asin(x))));
            }
            case 1: {
                return (float)(Math.abs(Math.asin(z)) + Math.abs(Math.asin(x)));
            }
            case 2: {
                return (float)(Math.abs(Math.asin(y)) + Math.abs(Math.asin(x)));
            }
            case 3: {
                return (float)(Math.abs(Math.asin(y)) + Math.abs(Math.asin(x)));
            }
            case 4: {
                return (float)(Math.abs(Math.asin(y)) + Math.abs(Math.asin(z)));
            }
            case 5: {
                return (float)(Math.abs(Math.asin(y)) + Math.abs(Math.asin(z)));
            }
        }
        return (float)(-Math.asin(y));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected LightSource createLightSource(int red, int green, int blue) {
        return ((ClientProxy)IHLMod.proxy).getLightHandler().calculateLightSource(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 256, red, green, blue, new double[]{(float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 0.5f, (float)this.field_145849_e + 0.5f, this.directionX, this.directionY, this.directionZ, 0.8});
    }

    private float getVectorYawAngle(float x, float y, float z) {
        switch (this.getFacing()) {
            case 0: {
                if (z >= 0.0f) {
                    return (float)(Math.acos((double)x / Math.sqrt(x * x + z * z)) - 1.5707963267948966);
                }
                return (float)(-Math.acos((double)x / Math.sqrt(x * x + z * z)) - 1.5707963267948966);
            }
            case 1: {
                if (z >= 0.0f) {
                    return (float)(Math.acos((double)x / Math.sqrt(x * x + z * z)) - 1.5707963267948966);
                }
                return (float)(-Math.acos((double)x / Math.sqrt(x * x + z * z)) - 1.5707963267948966);
            }
            case 2: {
                if (y >= 0.0f) {
                    return (float)(-Math.acos((double)x / Math.sqrt(x * x + y * y)) - 1.5707963267948966);
                }
                return (float)(Math.acos((double)x / Math.sqrt(x * x + y * y)) - 1.5707963267948966);
            }
            case 3: {
                if (y >= 0.0f) {
                    return (float)(-Math.acos((double)x / Math.sqrt(x * x + y * y)) - 1.5707963267948966);
                }
                return (float)(Math.acos((double)x / Math.sqrt(x * x + y * y)) - 1.5707963267948966);
            }
            case 4: {
                if (y >= 0.0f) {
                    return (float)(-Math.acos((double)z / Math.sqrt(z * z + y * y)) - 1.5707963267948966);
                }
                return (float)(Math.acos((double)z / Math.sqrt(z * z + y * y)) - 1.5707963267948966);
            }
            case 5: {
                if (y >= 0.0f) {
                    return (float)(-Math.acos((double)z / Math.sqrt(z * z + y * y)) - 1.5707963267948966);
                }
                return (float)(Math.acos((double)z / Math.sqrt(z * z + y * y)) - 1.5707963267948966);
            }
        }
        return 0.0f;
    }

    public void onNetworkEvent(int event) {
        this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "ihl:spotlightRotating", 10.0f, 1.0f, true);
    }
}

