/*
 * Decompiled with CFR 0.152.
 */
package ihl.explosion;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ihl.IHLCreativeTab;
import ihl.explosion.ExplosiveTileEntity;
import ihl.items_blocks.IHLItemBlock;
import ihl.processing.metallurgy.MuffleFurnanceTileEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ExplosiveBlock
extends Block
implements ITileEntityProvider {
    IIcon[] textures = new IIcon[6];

    public ExplosiveBlock() {
        super(Material.field_151590_u);
        this.func_149647_a(IHLCreativeTab.tab);
        this.func_149663_c("ihlExplosive");
        this.func_149711_c(2.0f);
        this.func_149752_b(1.0f);
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack result = new ItemStack(item);
        result.field_77990_d = new NBTTagCompound();
        result.field_77990_d.func_74768_a("explosionType", 1);
        result.field_77990_d.func_74768_a("explosionPower", 31000);
        itemList.add(result);
        result = new ItemStack(item);
        result.field_77990_d = new NBTTagCompound();
        result.field_77990_d.func_74768_a("explosionType", 1);
        result.field_77990_d.func_74768_a("explosionPower", Integer.MAX_VALUE);
        itemList.add(result);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.1f, 1.0f);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.1f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1f);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
        this.func_149676_a(0.9f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
        this.func_149676_a(0.0f, 0.0f, 0.9f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
        this.func_149683_g();
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void init() {
        GameRegistry.registerBlock((Block)new ExplosiveBlock(), IHLItemBlock.class, (String)"ihlExplosive");
        GameRegistry.registerTileEntity(ExplosiveTileEntity.class, (String)"explosiveTileEntity");
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int flag) {
        super.func_149690_a(world, x, y, z, meta, chance, flag);
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new ExplosiveTileEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("ihl:explosiveBlockSide");
        this.textures[0] = par1IconRegister.func_94245_a("ihl:explosiveBlockBottom");
        this.textures[1] = par1IconRegister.func_94245_a("ihl:explosiveBlockTop");
        this.textures[4] = this.textures[5] = this.field_149761_L;
        this.textures[3] = this.textures[5];
        this.textures[2] = this.textures[5];
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int i, float pos_x, float pos_y, float pos_z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (IC2.platform.isSimulating() && te instanceof ExplosiveTileEntity) {
            return ((ExplosiveTileEntity)te).ignite(player);
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (IC2.platform.isSimulating() && te instanceof ExplosiveTileEntity) {
            int[] xyz = new int[]{0, 0, 1, 0, 0, -1, 0, 0};
            for (int i = 2; i < xyz.length; ++i) {
                if (world.func_147439_a(x + xyz[i - 2], y + xyz[i - 1], z + xyz[i]) != Blocks.field_150480_ab || te.func_145837_r()) continue;
                ((ExplosiveTileEntity)te).ignite();
            }
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        TileEntity t = world.func_147438_o(x, y, z);
        if (t != null) {
            t.func_145839_a(itemStack.field_77990_d);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149691_a(side, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.textures[side];
    }

    public boolean func_149696_a(World world, int x, int y, int z, int metadata, int flag) {
        return true;
    }

    public int func_149645_b() {
        return 0;
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getInnerTextureForBlockRenderer() {
        return this.field_149761_L;
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public float func_149638_a(Entity entity) {
        return -1.0f;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ExplosiveTileEntity && !((ExplosiveTileEntity)te).func_145837_r()) {
            return -((ExplosiveTileEntity)te).explosionPower;
        }
        return -1.0f;
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ExplosiveTileEntity) {
            ((ExplosiveTileEntity)te).createExplosion(null);
        }
    }

    public static enum ExplosiveType {
        MuffleFurnace("muffleFurnance", MuffleFurnanceTileEntity.class, true, new ItemStack(Items.field_151118_aC));

        String unlocalizedName;
        Class<?> teclass;
        boolean isNormalBlock = true;
        ItemStack itemDroppedOnBlockDestroy;

        private ExplosiveType(String unlocalizedName1, Class<?> teclass1, boolean isNormalBlock1, ItemStack itemDroppedOnBlockDestroy1) {
            this.unlocalizedName = unlocalizedName1;
            this.teclass = teclass1;
            this.isNormalBlock = isNormalBlock1;
            this.itemDroppedOnBlockDestroy = itemDroppedOnBlockDestroy1;
        }
    }
}

