/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GT_Values;
import gttweaker.mods.gregtech.AddMultipleRecipeAction;
import gttweaker.util.ArrayHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Electrolyzer")
@ModOnly(value={"gregtech"})
public class Electrolyzer {
    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, ILiquidStack fluidOutput, IIngredient input, IIngredient cells, ILiquidStack fluidInput, int[] chances, int durationTicks, int euPerTick) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError((String)"Electrolyzer must have at least 1 output");
        } else if (outputs.length != chances.length) {
            MineTweakerAPI.logError((String)"Number of Outputs does not equal number of Chances");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Electrolyzer recipe with Liquid support for " + input, new Object[]{input, cells, fluidInput, fluidOutput, outputs[0], ArrayHelper.itemOrNull(outputs, 1), ArrayHelper.itemOrNull(outputs, 2), ArrayHelper.itemOrNull(outputs, 3), ArrayHelper.itemOrNull(outputs, 4), ArrayHelper.itemOrNull(outputs, 5), chances, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    GT_Values.RA.addElectrolyzerRecipe(i.nextItem(), i.nextItem(), i.nextFluid(), i.nextFluid(), i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem(), i.nextIntArr(), i.nextInt(), i.nextInt());
                }
            });
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IIngredient input, int cells, int durationTicks, int euPerTick) {
        if (outputs.length == 0) {
            MineTweakerAPI.logError((String)"Electrolyzer recipe requires at least 1 input");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding electrolyzer recipe with input " + input, new Object[]{input, cells, outputs[0], ArrayHelper.itemOrNull(outputs, 1), ArrayHelper.itemOrNull(outputs, 2), ArrayHelper.itemOrNull(outputs, 3), ArrayHelper.itemOrNull(outputs, 4), ArrayHelper.itemOrNull(outputs, 5), durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    GT_Values.RA.addElectrolyzerRecipe(i.nextItem(), i.nextInt(), i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem(), i.nextInt(), i.nextInt());
                }
            });
        }
    }
}

