/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gttweaker.util.exception.AnyIngredientException;
import gttweaker.util.exception.EmptyIngredientException;
import gttweaker.util.exception.OutOfStackSizeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class AddMultipleRecipeAction
extends OneWayAction {
    private String description;
    private List<List<Object>> recipesData;

    private static void extendBySingle(Object singleArg, List<List<Object>> recipesData) {
        for (List<Object> recipeData : recipesData) {
            recipeData.add(singleArg);
        }
    }

    private static void extendByMultiple(List args, List<List<Object>> recipesData) {
        List<List<Object>> originData = AddMultipleRecipeAction.fullCopy(recipesData);
        recipesData.clear();
        for (Object singleArg : args) {
            List<List<Object>> tmp = AddMultipleRecipeAction.fullCopy(originData);
            AddMultipleRecipeAction.extendBySingle(singleArg, tmp);
            recipesData.addAll(tmp);
        }
    }

    private static List<List<Object>> fullCopy(List<List<Object>> recipesData) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(recipesData.size());
        for (List<Object> recipeData : recipesData) {
            result.add(new ArrayList<Object>(recipeData));
        }
        return result;
    }

    private void addArgument(Object recipeArg) {
        if (recipeArg instanceof ILiquidStack) {
            AddMultipleRecipeAction.extendBySingle(MineTweakerMC.getLiquidStack((ILiquidStack)((ILiquidStack)recipeArg)), this.recipesData);
        } else if (recipeArg instanceof ILiquidStack[]) {
            AddMultipleRecipeAction.extendBySingle(MineTweakerMC.getLiquidStacks((ILiquidStack[])((ILiquidStack[])recipeArg)), this.recipesData);
        } else if (recipeArg instanceof IItemStack) {
            AddMultipleRecipeAction.extendBySingle(MineTweakerMC.getItemStack((IItemStack)((IItemStack)recipeArg)), this.recipesData);
        } else if (recipeArg instanceof IItemStack[]) {
            AddMultipleRecipeAction.extendBySingle(MineTweakerMC.getItemStacks((IItemStack[])((IItemStack[])recipeArg)), this.recipesData);
        } else if (recipeArg instanceof IIngredient) {
            AddMultipleRecipeAction.extendByMultiple(this.getItemStacks((IIngredient)recipeArg), this.recipesData);
        } else {
            AddMultipleRecipeAction.extendBySingle(recipeArg, this.recipesData);
        }
    }

    private List<ItemStack> getItemStacks(IIngredient ingredientArg) {
        List items = ingredientArg.getItems();
        if (items == null) {
            throw new AnyIngredientException();
        }
        if (items.size() == 0) {
            throw new EmptyIngredientException(ingredientArg);
        }
        List<ItemStack> itemStackList = Arrays.asList(MineTweakerMC.getItemStacks((List)items));
        int amount = ingredientArg.getAmount();
        if (amount < 0) {
            throw new RuntimeException("Negative amount for ingredient " + ingredientArg);
        }
        for (ItemStack stack : itemStackList) {
            if (amount > stack.func_77976_d()) {
                throw new OutOfStackSizeException(ingredientArg, amount);
            }
            stack.field_77994_a = amount;
        }
        return itemStackList;
    }

    protected AddMultipleRecipeAction(String description, Object ... recipeArgs) {
        this.description = description;
        this.recipesData = new ArrayList<List<Object>>(recipeArgs.length);
        this.recipesData.add(new ArrayList());
        try {
            for (Object recipeArg : recipeArgs) {
                this.addArgument(recipeArg);
            }
        }
        catch (Exception e) {
            MineTweakerAPI.logError((String)e.toString());
        }
    }

    protected abstract void applySingleRecipe(ArgIterator var1);

    public void apply() {
        for (List<Object> recipeData : this.recipesData) {
            this.applySingleRecipe(new ArgIterator(recipeData));
        }
    }

    public String describe() {
        return this.description;
    }

    public Object getOverrideKey() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AddMultipleRecipeAction that = (AddMultipleRecipeAction)((Object)o);
        return this.recipesData != null ? this.recipesData.equals(that.recipesData) : that.recipesData == null;
    }

    public int hashCode() {
        return this.recipesData != null ? this.recipesData.hashCode() : 0;
    }

    protected static class ArgIterator {
        private Iterator<Object> iterator;

        public ArgIterator(List<Object> args) {
            this.iterator = args.iterator();
        }

        public ItemStack nextItem() {
            return (ItemStack)this.iterator.next();
        }

        public ItemStack[] nextItemArr() {
            return (ItemStack[])this.iterator.next();
        }

        public FluidStack nextFluid() {
            return (FluidStack)this.iterator.next();
        }

        public FluidStack[] nextFluidArr() {
            return (FluidStack[])this.iterator.next();
        }

        public int nextInt() {
            return (Integer)this.iterator.next();
        }

        public int[] nextIntArr() {
            return (int[])this.iterator.next();
        }

        public boolean nextBool() {
            return (Boolean)this.iterator.next();
        }
    }
}

