/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.AdvMachines.te;

import com.chocohead.AdvMachines.te.TileEntityHeatingMachine;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.comp.Fluids;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.network.GuiSynced;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class TileEntityHeatingWaterMachine
extends TileEntityHeatingMachine {
    @GuiSynced
    protected final Fluids.InternalFluidTank tank = new Fluids.InternalFluidTank("tank", Util.allFacings, Util.noFacings, Fluids.fluidPredicate((Fluid[])new Fluid[]{FluidRegistry.WATER}), 8000){

        public int fillInternal(FluidStack resource, boolean doFill) {
            int out = super.fillInternal(resource, doFill);
            if (out > 0) {
                TileEntityHeatingWaterMachine.this.onFluidFill(doFill, out);
            }
            return out;
        }

        public boolean canDrain() {
            return false;
        }
    };
    protected final short activeWaterUse;

    public TileEntityHeatingWaterMachine(byte numberOfOutputs, IMachineRecipeManager<IRecipeInput, Collection<ItemStack>, ItemStack> recipeSet, short activeWaterUse) {
        super(numberOfOutputs, recipeSet);
        ((Fluids)this.addComponent((TileEntityComponent)new Fluids((TileEntityBlock)this))).addTank(this.tank);
        this.activeWaterUse = activeWaterUse;
    }

    public TileEntityHeatingWaterMachine(byte tier, byte numberOfOutputs, IMachineRecipeManager<IRecipeInput, Collection<ItemStack>, ItemStack> recipeSet, short activeWaterUse) {
        super(tier, numberOfOutputs, recipeSet);
        ((Fluids)this.addComponent((TileEntityComponent)new Fluids((TileEntityBlock)this))).addTank(this.tank);
        this.activeWaterUse = activeWaterUse;
    }

    public TileEntityHeatingWaterMachine(byte numberOfOutputs, IMachineRecipeManager<IRecipeInput, Collection<ItemStack>, ItemStack> recipeSet, int idleEU, int activeEU, short activeWaterUse) {
        super(numberOfOutputs, recipeSet, idleEU, activeEU);
        ((Fluids)this.addComponent((TileEntityComponent)new Fluids((TileEntityBlock)this))).addTank(this.tank);
        this.activeWaterUse = activeWaterUse;
    }

    public TileEntityHeatingWaterMachine(byte tier, byte numberOfOutputs, IMachineRecipeManager<IRecipeInput, Collection<ItemStack>, ItemStack> recipeSet, int idleEU, int activeEU, short activeWaterUse) {
        super(tier, numberOfOutputs, recipeSet, idleEU, activeEU);
        ((Fluids)this.addComponent((TileEntityComponent)new Fluids((TileEntityBlock)this))).addTank(this.tank);
        this.activeWaterUse = activeWaterUse;
    }

    protected void onFluidFill(boolean didFill, int amount) {
    }

    @Override
    public boolean canRun() {
        int waterNeeded = this.getIdleWaterUse();
        if (waterNeeded == 0) {
            return true;
        }
        FluidStack stack = this.tank.drainInternal(waterNeeded, false);
        if (stack != null && stack.amount == waterNeeded) {
            this.tank.drainInternal(waterNeeded, true);
            return true;
        }
        return false;
    }

    protected abstract int getIdleWaterUse();

    @Override
    public boolean canOperate() {
        FluidStack stack;
        return super.canOperate() && (stack = this.tank.drainInternal((int)this.activeWaterUse, false)) != null && stack.amount == this.activeWaterUse;
    }

    @Override
    public void operate() {
        super.operate();
        this.tank.drainInternal((int)this.activeWaterUse, true);
    }

    protected boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = StackUtil.get((EntityPlayer)player, (EnumHand)hand);
        if (!StackUtil.isEmpty((ItemStack)heldItem)) {
            int space = this.tank.getCapacity() - this.tank.getFluidAmount();
            if (FluidUtil.tryEmptyContainer((ItemStack)heldItem, (IFluidHandler)this.tank, (int)space, (EntityPlayer)player, (boolean)false).success) {
                FluidActionResult stack = FluidUtil.tryEmptyContainer((ItemStack)heldItem, (IFluidHandler)this.tank, (int)space, (EntityPlayer)player, (boolean)true);
                assert (stack.success);
                if (StackUtil.getSize((ItemStack)heldItem) > 1) {
                    StackUtil.consumeOrError((EntityPlayer)player, (EnumHand)hand, (int)1);
                    StackUtil.storeInventoryItem((ItemStack)stack.result, (EntityPlayer)player, (boolean)false);
                } else {
                    StackUtil.set((EntityPlayer)player, (EnumHand)hand, (ItemStack)stack.result);
                }
                return true;
            }
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }
}

