/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.advsolar;

import com.chocohead.advsolar.AdvancedSolarPanels;
import com.chocohead.advsolar.IMolecularTransformerRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.MachineRecipe;
import ic2.api.recipe.MachineRecipeResult;
import ic2.core.init.MainConfig;
import ic2.core.recipe.RecipeInputItemStack;
import ic2.core.recipe.RecipeInputOreDict;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

class MolecularTransformerRecipeManager
implements IMolecularTransformerRecipeManager {
    private final Map<IMolecularTransformerRecipeManager.Input, MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>> recipes = new HashMap<IMolecularTransformerRecipeManager.Input, MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>>();
    private final Map<Item, List<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>>> recipeCache = new IdentityHashMap<Item, List<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>>>();
    private final List<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>> uncacheableRecipes = new ArrayList<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>>();
    private boolean oreRegisterEventSubscribed;

    MolecularTransformerRecipeManager() {
    }

    static void showError(String message) {
        if (!MainConfig.ignoreInvalidRecipes) {
            throw new RuntimeException(message);
        }
        AdvancedSolarPanels.log.warn(message);
    }

    @Override
    public boolean addRecipe(IRecipeInput input, int totalEU, ItemStack output, boolean replace) {
        return this.addRecipe(new IMolecularTransformerRecipeManager.Input(input, totalEU), output, null, replace);
    }

    public boolean addRecipe(IMolecularTransformerRecipeManager.Input input, ItemStack output, NBTTagCompound metadata, boolean replace) {
        if (input == null) {
            MolecularTransformerRecipeManager.showError("Invalid recipe input: null");
            return false;
        }
        if (StackUtil.isEmpty((ItemStack)output)) {
            MolecularTransformerRecipeManager.showError("Invalid recipe output: " + StackUtil.toStringSafe((ItemStack)output));
            return false;
        }
        if (input.input.matches(output) && (metadata == null || !metadata.func_74764_b("ignoreSameInputOutput"))) {
            MolecularTransformerRecipeManager.showError("The output ItemStack " + StackUtil.toStringSafe((ItemStack)output) + " is the same as the recipe input " + input + ".");
            return false;
        }
        for (ItemStack is : input.input.getInputs()) {
            MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack> recipe = this.getRecipe(is);
            if (recipe == null) continue;
            if (replace) {
                do {
                    this.recipes.remove(input);
                    this.removeCachedRecipes(input);
                } while ((recipe = this.getRecipe(is)) != null);
                continue;
            }
            return false;
        }
        MachineRecipe recipe = new MachineRecipe((Object)input, (Object)output.func_77946_l(), metadata);
        this.recipes.put(input, (MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>)recipe);
        this.addToCache((MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>)recipe);
        return true;
    }

    public MachineRecipeResult<IMolecularTransformerRecipeManager.Input, ItemStack, ItemStack> apply(ItemStack input, boolean acceptTest) {
        ItemStack adjustedInput;
        if (StackUtil.isEmpty((ItemStack)input)) {
            return null;
        }
        MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack> recipe = this.getRecipe(input);
        if (recipe == null) {
            return null;
        }
        IRecipeInput recipeInput = ((IMolecularTransformerRecipeManager.Input)recipe.getInput()).input;
        if (StackUtil.getSize((ItemStack)input) < recipeInput.getAmount()) {
            return null;
        }
        if (input.func_77973_b().hasContainerItem(input) && !StackUtil.isEmpty((ItemStack)(adjustedInput = input.func_77973_b().getContainerItem(input)))) {
            if (StackUtil.getSize((ItemStack)input) != recipeInput.getAmount()) {
                return null;
            }
            adjustedInput = StackUtil.copy((ItemStack)input);
        } else {
            adjustedInput = StackUtil.copyWithSize((ItemStack)input, (int)(StackUtil.getSize((ItemStack)input) - recipeInput.getAmount()));
        }
        return recipe.getResult((Object)adjustedInput);
    }

    @Override
    public int getTotalEUNeeded(ItemStack input) {
        IMolecularTransformerRecipeManager.Input recipe = (IMolecularTransformerRecipeManager.Input)this.getRecipe(input).getInput();
        return recipe == null ? -1 : recipe.totalEU;
    }

    public boolean isIterable() {
        return true;
    }

    public Iterable<? extends MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>> getRecipes() {
        return new Iterable<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>>(){

            @Override
            public Iterator<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>> iterator() {
                return new Iterator<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>>(){
                    private final Iterator<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>> recipeIt;
                    private IMolecularTransformerRecipeManager.Input lastInput;
                    {
                        this.recipeIt = MolecularTransformerRecipeManager.this.recipes.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.recipeIt.hasNext();
                    }

                    @Override
                    public MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack> next() {
                        MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack> next = this.recipeIt.next();
                        this.lastInput = (IMolecularTransformerRecipeManager.Input)next.getInput();
                        return next;
                    }

                    @Override
                    public void remove() {
                        this.recipeIt.remove();
                        MolecularTransformerRecipeManager.this.removeCachedRecipes(this.lastInput);
                    }
                };
            }
        };
    }

    @SubscribeEvent
    public void onOreRegister(OreDictionary.OreRegisterEvent event) {
        Item item = event.getOre().func_77973_b();
        if (item == null) {
            return;
        }
        for (MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack> rawRecipe : this.recipes.values()) {
            if (((IMolecularTransformerRecipeManager.Input)rawRecipe.getInput()).input.getClass() != RecipeInputOreDict.class) continue;
            RecipeInputOreDict recipe = (RecipeInputOreDict)((IMolecularTransformerRecipeManager.Input)rawRecipe.getInput()).input;
            if (!recipe.input.equals(event.getName())) continue;
            this.addToCache(item, rawRecipe);
        }
    }

    private MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack> getRecipe(ItemStack input) {
        if (StackUtil.isEmpty((ItemStack)input)) {
            return null;
        }
        List<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>> recipes = this.recipeCache.get(input.func_77973_b());
        if (recipes != null) {
            for (MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack> recipe : recipes) {
                if (!((IMolecularTransformerRecipeManager.Input)recipe.getInput()).input.matches(input)) continue;
                return recipe;
            }
        }
        for (MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack> recipe : this.uncacheableRecipes) {
            if (!((IMolecularTransformerRecipeManager.Input)recipe.getInput()).input.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    private void addToCache(MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack> recipe) {
        Collection<Item> items = this.getItemsFromRecipe(((IMolecularTransformerRecipeManager.Input)recipe.getInput()).input);
        if (items != null) {
            for (Item item : items) {
                this.addToCache(item, recipe);
            }
            if (!this.oreRegisterEventSubscribed && ((IMolecularTransformerRecipeManager.Input)recipe.getInput()).input.getClass() == RecipeInputOreDict.class) {
                MinecraftForge.EVENT_BUS.register((Object)this);
                this.oreRegisterEventSubscribed = true;
            }
        } else {
            this.uncacheableRecipes.add(recipe);
        }
    }

    private void addToCache(Item item, MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack> recipe) {
        List<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>> recipes = this.recipeCache.get(item);
        if (recipes == null) {
            recipes = new ArrayList<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>>();
            this.recipeCache.put(item, recipes);
        }
        if (!recipes.contains(recipe)) {
            recipes.add(recipe);
        }
    }

    private Collection<Item> getItemsFromRecipe(IRecipeInput recipe) {
        Class<?> recipeClass = recipe.getClass();
        if (recipeClass == RecipeInputItemStack.class || recipeClass == RecipeInputOreDict.class) {
            List inputs = recipe.getInputs();
            Set<Item> ret = Collections.newSetFromMap(new IdentityHashMap(inputs.size()));
            for (ItemStack stack : inputs) {
                ret.add(stack.func_77973_b());
            }
            return ret;
        }
        return null;
    }

    private void removeCachedRecipes(IMolecularTransformerRecipeManager.Input input) {
        Collection<Item> items = this.getItemsFromRecipe(input.input);
        if (items != null) {
            for (Item item : items) {
                List<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>> recipes = this.recipeCache.get(item);
                if (recipes == null) {
                    AdvancedSolarPanels.log.warn("Inconsistent recipe cache, the entry for the item " + item + " is missing.");
                    continue;
                }
                MolecularTransformerRecipeManager.removeInputFromRecipes(recipes.iterator(), input);
                if (!recipes.isEmpty()) continue;
                this.recipeCache.remove(item);
            }
        } else {
            MolecularTransformerRecipeManager.removeInputFromRecipes(this.uncacheableRecipes.iterator(), input);
        }
    }

    private static void removeInputFromRecipes(Iterator<MachineRecipe<IMolecularTransformerRecipeManager.Input, ItemStack>> it, IMolecularTransformerRecipeManager.Input target) {
        assert (target != null);
        while (it.hasNext()) {
            if (!target.equals(it.next().getInput())) continue;
            it.remove();
        }
    }
}

