/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.nuclearcontrol.tiles.gui.elements;

import com.chocohead.nuclearcontrol.tiles.gui.elements.ColourBox;
import ic2.core.GuiIC2;
import ic2.core.gui.GuiElement;
import ic2.core.gui.MouseButton;
import ic2.core.util.Ic2Color;
import java.util.List;
import java.util.function.Function;

public class ColourBoxArray
extends GuiElement<ColourBoxArray> {
    protected final ColourBox[] boxes;
    protected final int padding;
    protected IBoxWatcher watcher;
    protected Function<ColourBox, List<String>> tooltipHandler;
    protected boolean horizonal = true;
    protected int selectedBox = -1;

    public ColourBoxArray(GuiIC2<?> gui, int x, int y, int padding, Ic2Color ... colours) {
        super(gui, x, y, (14 + padding) * colours.length, 14);
        ColourBox[] boxes = new ColourBox[colours.length];
        for (int i = 0; i < colours.length; ++i) {
            boxes[i] = new ColourBox(gui, x + (14 + padding) * i, y, colours[i]);
        }
        this.boxes = boxes;
        this.padding = padding;
    }

    public ColourBoxArray flipXY() {
        int temp = this.width;
        this.width = this.height;
        this.height = temp;
        boolean bl = this.horizonal = !this.horizonal;
        if (this.horizonal) {
            for (int i = 0; i < this.boxes.length; ++i) {
                ColourBox box = this.boxes[i];
                box.setX(this.x + (14 + this.padding) * i);
                box.setY(this.y);
            }
        } else {
            for (int i = 0; i < this.boxes.length; ++i) {
                ColourBox box = this.boxes[i];
                box.setX(this.x);
                box.setY(this.y + (14 + this.padding) * i);
            }
        }
        return this;
    }

    public ColourBoxArray withSelected(int number) {
        if (this.selectedBox >= 0) {
            this.boxes[this.selectedBox].setSelected(false);
        }
        this.selectedBox = number;
        this.boxes[number].setSelected(true);
        return this;
    }

    public ColourBoxArray withChangeHandler(IBoxWatcher watcher) {
        this.watcher = watcher;
        return this;
    }

    public ColourBoxArray withBoxTooltipHandler(Function<ColourBox, List<String>> handler) {
        this.tooltipHandler = handler;
        return this;
    }

    public void drawBackground(int mouseX, int mouseY) {
        for (ColourBox box : this.boxes) {
            box.drawBackground(mouseX, mouseY);
        }
    }

    public void drawForeground(int mouseX, int mouseY) {
        int side;
        int mouse;
        if (this.tooltipHandler == null) {
            super.drawForeground(mouseX, mouseY);
            return;
        }
        if (this.horizonal) {
            if (mouseY < this.y || mouseY > this.y + this.height) {
                return;
            }
            mouse = mouseX - this.x;
            side = 14;
        } else {
            if (mouseX < this.x || mouseX > this.x + this.width) {
                return;
            }
            mouse = mouseY - this.y;
            side = 14;
        }
        int left = 0;
        int right = 1;
        while (left < this.boxes.length) {
            List<String> tooltip;
            if ((side + this.padding) * left <= mouse && (side + this.padding) * right >= mouse && !(tooltip = this.tooltipHandler.apply(this.boxes[left])).isEmpty()) {
                this.gui.drawTooltip(mouseX, mouseY, tooltip);
            }
            ++left;
            ++right;
        }
    }

    protected boolean onMouseClick(int mouseX, int mouseY, MouseButton button) {
        int side;
        int mouse;
        if (this.horizonal) {
            if (mouseY < this.y || mouseY > this.y + this.height) {
                return false;
            }
            mouse = mouseX - this.x;
            side = 14;
        } else {
            if (mouseX < this.x || mouseX > this.x + this.width) {
                return false;
            }
            mouse = mouseY - this.y;
            side = 14;
        }
        int left = 0;
        int right = 1;
        while (left < this.boxes.length) {
            if ((side + this.padding) * left <= mouse && (side + this.padding) * right >= mouse) {
                int old = this.selectedBox;
                this.selectedBox = left;
                ColourBox before = old < 0 ? null : this.boxes[old].setSelected(false);
                ColourBox now = this.boxes[left].setSelected(true);
                if (this.watcher != null) {
                    this.watcher.onBoxChange(before, now);
                }
                return true;
            }
            ++left;
            ++right;
        }
        return false;
    }

    public static interface IBoxWatcher {
        public void onBoxChange(ColourBox var1, ColourBox var2);
    }
}

