/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.TriAddon.te;

import com.chocohead.AdvMachines.api.IRecipeLoadingTeBlock;
import com.chocohead.AdvMachines.api.Recipes;
import com.chocohead.AdvMachines.te.TileEntityCentrifugeExtractor;
import com.chocohead.AdvMachines.te.TileEntityCompactingRecycler;
import com.chocohead.AdvMachines.te.TileEntityImpellerizedRoller;
import com.chocohead.AdvMachines.te.TileEntityLiquescentExtruder;
import com.chocohead.AdvMachines.te.TileEntityRotaryMacerator;
import com.chocohead.AdvMachines.te.TileEntitySingularityCompressor;
import com.chocohead.AdvMachines.te.TileEntityThermalWasher;
import com.chocohead.AdvMachines.te.TileEntityWaterJetCutter;
import com.chocohead.TriAddon.TriAddon;
import com.chocohead.TriAddon.te.TileEntityFakeTeleporter;
import com.chocohead.advsolar.tiles.TileEntityAdvancedSolar;
import com.chocohead.advsolar.tiles.TileEntityHybridSolar;
import com.chocohead.advsolar.tiles.TileEntityMolecularAssembler;
import com.chocohead.advsolar.tiles.TileEntityQuantumGenerator;
import com.chocohead.advsolar.tiles.TileEntityQuantumSolar;
import com.chocohead.advsolar.tiles.TileEntityUltimateHybridSolar;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityBlock;
import ic2.core.item.block.ItemBlockTileEntity;
import ic2.core.ref.TeBlock;
import ic2.core.util.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum AddonTEs implements IRecipeLoadingTeBlock,
ITeBlock.ITeBlockCreativeRegisterer
{
    rotary_macerator(TileEntityRotaryMacerator.class, 0, true),
    singularity_compressor(TileEntitySingularityCompressor.class, 1, true),
    centrifuge_extractor(TileEntityCentrifugeExtractor.class, 2, true),
    compacting_recycler(TileEntityCompactingRecycler.class, 3, true),
    liquescent_extruder(TileEntityLiquescentExtruder.class, 4, true),
    impellerized_roller(TileEntityImpellerizedRoller.class, 5, true),
    water_jet_cutter(TileEntityWaterJetCutter.class, 6, true),
    thermal_washer(TileEntityThermalWasher.class, 7, true),
    molecular_transformer(TileEntityMolecularAssembler.class, 8, false, EnumRarity.RARE),
    quantum_generator(TileEntityQuantumGenerator.class, 9, false, EnumRarity.EPIC),
    advanced_solar_panel(TileEntityAdvancedSolar.class, 10, false),
    hybrid_solar_panel(TileEntityHybridSolar.class, 11, false, EnumRarity.RARE),
    ultimate_solar_panel(TileEntityUltimateHybridSolar.class, 12, false, EnumRarity.EPIC),
    quantum_solar_panel(TileEntityQuantumSolar.class, 13, false, EnumRarity.EPIC),
    fake_teleporter(TileEntityFakeTeleporter.class, 14, false, EnumRarity.RARE);

    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    private final boolean machine;
    private final EnumRarity rarity;
    private TileEntityBlock dummyTe;
    private static final AddonTEs[] ALL_VALUES;
    public static final AddonTEs[] ALL_MACHINES;
    public static final AddonTEs[] ALL_SOLARS;
    public static final ResourceLocation IDENTITY;

    private AddonTEs(Class<? extends TileEntityBlock> teClass, int itemMeta, boolean machine) {
        this(teClass, itemMeta, machine, EnumRarity.UNCOMMON);
    }

    private AddonTEs(Class<? extends TileEntityBlock> teClass, int itemMeta, boolean machine, EnumRarity rarity) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
        this.machine = machine;
        this.rarity = rarity;
        GameRegistry.registerTileEntity(teClass, (String)((machine ? "advanced_machines" : "advanced_solar_panels") + ':' + this.getName()));
    }

    public boolean hasItem() {
        return true;
    }

    public String getName() {
        return this.name();
    }

    public int getId() {
        return this.itemMeta;
    }

    public ResourceLocation getIdentifier() {
        return IDENTITY;
    }

    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    public boolean hasActive() {
        return this.machine || this == quantum_generator || this == fake_teleporter;
    }

    public float getHardness() {
        return this.machine ? 5.0f : 3.0f;
    }

    public float getExplosionResistance() {
        return this.machine ? 10.0f : 15.0f;
    }

    public TeBlock.HarvestTool getHarvestTool() {
        return TeBlock.HarvestTool.Pickaxe;
    }

    public TeBlock.DefaultDrop getDefaultDrop() {
        return this.machine ? TeBlock.DefaultDrop.AdvMachine : TeBlock.DefaultDrop.Self;
    }

    public boolean allowWrenchRotating() {
        return this == fake_teleporter;
    }

    public Set<EnumFacing> getSupportedFacings() {
        return this == fake_teleporter ? Util.allFacings : Util.horizontalFacings;
    }

    public EnumRarity getRarity() {
        return this.rarity;
    }

    public Material getMaterial() {
        return Material.field_151573_f;
    }

    public void addSubBlocks(NonNullList<ItemStack> list, BlockTileEntity block, ItemBlockTileEntity item, CreativeTabs tab) {
        if (tab == TriAddon.tab) {
            for (AddonTEs type : ALL_VALUES) {
                if (!type.hasItem()) continue;
                list.add((Object)block.getItemStack((ITeBlock)type));
            }
        }
    }

    @Override
    public String[] getRecipeCategories() {
        if (!this.machine) {
            throw new IllegalStateException("Gee, we've no idea for " + this);
        }
        return new String[]{this.getName()};
    }

    @Override
    public IMachineRecipeManager<IRecipeInput, Collection<ItemStack>, ItemStack> getManager(String category) {
        switch (this) {
            case rotary_macerator: {
                return Recipes.rotaryMacerator;
            }
            case singularity_compressor: {
                return Recipes.singularityCompressor;
            }
            case centrifuge_extractor: {
                return Recipes.centrifugeExtractor;
            }
            case compacting_recycler: {
                return Recipes.compactingRecycler;
            }
            case liquescent_extruder: {
                return Recipes.liquescentExtruder;
            }
            case impellerized_roller: {
                return Recipes.impellerizedRoller;
            }
            case water_jet_cutter: {
                return Recipes.waterJetCutter;
            }
            case thermal_washer: {
                return Recipes.thermalWasher;
            }
        }
        throw new IllegalStateException("Gee, we've no idea for " + this);
    }

    @Override
    public IRecipeLoadingTeBlock.MachineType getType(String category) {
        switch (this) {
            case compacting_recycler: {
                return IRecipeLoadingTeBlock.MachineType.RECYCLER;
            }
        }
        if (this.machine) {
            return IRecipeLoadingTeBlock.MachineType.NORMAL;
        }
        throw new IllegalStateException("Gee, we've no idea for " + this);
    }

    public void setPlaceHandler(TeBlock.ITePlaceHandler handler) {
        throw new UnsupportedOperationException("Tri-Addon's blocks don't need place handlers!");
    }

    public TeBlock.ITePlaceHandler getPlaceHandler() {
        return null;
    }

    public boolean isTransparent() {
        return false;
    }

    public static void buildDummies() {
        ModContainer mc = Loader.instance().activeModContainer();
        if (mc == null || !"tri_addon".equals(mc.getModId())) {
            throw new IllegalAccessError("Don't mess with this please.");
        }
        for (AddonTEs block : ALL_VALUES) {
            if (block.teClass == null) continue;
            try {
                block.dummyTe = block.teClass.newInstance();
            }
            catch (Exception e) {
                if (!Util.inDev()) continue;
                e.printStackTrace();
            }
        }
    }

    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }

    static {
        ALL_VALUES = AddonTEs.values();
        ALL_MACHINES = (AddonTEs[])Arrays.stream(AddonTEs.values()).filter(te -> te.machine).toArray(AddonTEs[]::new);
        ALL_SOLARS = (AddonTEs[])Arrays.stream(AddonTEs.values()).filter(te -> !te.machine).toArray(AddonTEs[]::new);
        IDENTITY = new ResourceLocation("tri_addon", "machines");
    }
}

