/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.gravisuite;

import com.chocohead.gravisuite.items.ItemAdvancedChainsaw;
import com.chocohead.gravisuite.items.ItemAdvancedDrill;
import com.chocohead.gravisuite.items.ItemAdvancedElectricJetpack;
import com.chocohead.gravisuite.items.ItemAdvancedLappack;
import com.chocohead.gravisuite.items.ItemAdvancedNanoChestplate;
import com.chocohead.gravisuite.items.ItemCraftingThings;
import com.chocohead.gravisuite.items.ItemGraviChestplate;
import com.chocohead.gravisuite.items.ItemGraviTool;
import com.chocohead.gravisuite.items.ItemUltimateLappack;
import com.chocohead.gravisuite.items.ItemVajra;
import ic2.core.block.state.IIdProvider;
import ic2.core.ref.IItemModelProvider;
import ic2.core.ref.IMultiItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum GS_Items {
    ADVANCED_LAPPACK,
    ADVANCED_JETPACK,
    ADVANCED_NANO_CHESTPLATE,
    ULTIMATE_LAPPACK,
    GRAVI_CHESTPLATE,
    ADVANCED_DRILL,
    ADVANCED_CHAINSAW,
    GRAVITOOL,
    VAJRA,
    CRAFTING;

    private Item instance;

    public <T extends Item> T getInstance() {
        return (T)this.instance;
    }

    public <T extends Enum<T>> ItemStack getItemStack(T variant) {
        if (this.instance == null) {
            return null;
        }
        if (this.instance instanceof IMultiItem) {
            IMultiItem multiItem = (IMultiItem)this.instance;
            return multiItem.getItemStack((IIdProvider)variant);
        }
        if (variant == null) {
            return new ItemStack(this.instance);
        }
        throw new IllegalArgumentException("Not applicable");
    }

    public <T extends Item> void setInstance(T instance) {
        if (this.instance != null) {
            throw new IllegalStateException("Duplicate instances!");
        }
        this.instance = instance;
    }

    static void buildItems(Side side) {
        ADVANCED_LAPPACK.setInstance(new ItemAdvancedLappack());
        ADVANCED_JETPACK.setInstance(new ItemAdvancedElectricJetpack());
        ADVANCED_NANO_CHESTPLATE.setInstance(new ItemAdvancedNanoChestplate());
        ULTIMATE_LAPPACK.setInstance(new ItemUltimateLappack());
        GRAVI_CHESTPLATE.setInstance(new ItemGraviChestplate());
        ADVANCED_DRILL.setInstance(new ItemAdvancedDrill());
        ADVANCED_CHAINSAW.setInstance(new ItemAdvancedChainsaw());
        GRAVITOOL.setInstance(new ItemGraviTool());
        VAJRA.setInstance(new ItemVajra());
        CRAFTING.setInstance(new ItemCraftingThings());
        if (side == Side.CLIENT) {
            GS_Items.doModelGuf();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void doModelGuf() {
        for (GS_Items item : GS_Items.values()) {
            ((IItemModelProvider)item.getInstance()).registerModels(null);
        }
    }
}

