/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.advsolar;

import com.chocohead.TriAddon.TriAddon;
import com.chocohead.TriAddon.te.AddonTEs;
import com.chocohead.advsolar.ASP_Items;
import com.chocohead.advsolar.Configs;
import com.chocohead.advsolar.Recipes;
import com.chocohead.advsolar.gui.ProgressBars;
import com.chocohead.advsolar.items.ItemCraftingThings;
import com.chocohead.advsolar.renders.PrettyMolecularTransformerTESR;
import com.chocohead.advsolar.tiles.TileEntityMolecularAssembler;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.ITeBlock;
import ic2.core.block.TeBlockRegistry;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

@Mod(modid="advanced_solar_panels", name="Advanced Solar Panels", dependencies="required-after:ic2;", version="1.3", acceptedMinecraftVersions="[1.12,1.12.2]")
public final class AdvancedSolarPanels {
    public static final String MODID = "advanced_solar_panels";
    public static Logger log;
    public static BlockTileEntity machines;

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        log = event.getModLog();
        Configs.loadConfig(event.getSuggestedConfigurationFile(), event.getSide().isClient());
        machines = TeBlockRegistry.get((ResourceLocation)AddonTEs.IDENTITY);
        if (event.getSide().isClient()) {
            AdvancedSolarPanels.setupRenderingGuf();
        }
        ASP_Items.buildItems(event.getSide());
        OreDictionary.registerOre((String)"ingotUranium", (ItemStack)ASP_Items.CRAFTING.getItemStack(ItemCraftingThings.CraftingTypes.URANIUM_INGOT));
        OreDictionary.registerOre((String)"ingotIridium", (ItemStack)ASP_Items.CRAFTING.getItemStack(ItemCraftingThings.CraftingTypes.IRIDIUM_INGOT));
        OreDictionary.registerOre((String)"craftingSolarPanelHV", (ItemStack)machines.getItemStack((ITeBlock)AddonTEs.ultimate_solar_panel));
        OreDictionary.registerOre((String)"craftingSunnariumPart", (ItemStack)ASP_Items.CRAFTING.getItemStack(ItemCraftingThings.CraftingTypes.SUNNARIUM_PART));
        OreDictionary.registerOre((String)"craftingSunnarium", (ItemStack)ASP_Items.CRAFTING.getItemStack(ItemCraftingThings.CraftingTypes.SUNNARIUM));
        OreDictionary.registerOre((String)"craftingMTCore", (ItemStack)ASP_Items.CRAFTING.getItemStack(ItemCraftingThings.CraftingTypes.MT_CORE));
        OreDictionary.registerOre((String)"craftingMolecularTransformer", (ItemStack)machines.getItemStack((ITeBlock)AddonTEs.molecular_transformer));
    }

    @SideOnly(value=Side.CLIENT)
    private static void setupRenderingGuf() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMolecularAssembler.class, (TileEntitySpecialRenderer)new PrettyMolecularTransformerTESR());
        ForgeHooksClient.registerTESRItemStack((Item)machines.getItem(), (int)AddonTEs.molecular_transformer.getId(), AddonTEs.molecular_transformer.getTeClass());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Recipes.addCraftingRecipes();
        Recipes.addMachineRecipes();
        Recipes.addMolecularTransformerRecipes();
        ProgressBars.addStyles();
        TileEntityMolecularAssembler.MolecularOutput.registerNetwork();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide().isClient()) {
            TriAddon.doColourThings(log, new Item[]{ASP_Items.HYBRID_SOLAR_HELMET.getInstance(), ASP_Items.ULTIMATE_HYBRID_SOLAR_HELMET.getInstance()});
        }
    }
}

