/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.TriAddon.te;

import com.chocohead.advsolar.AdvancedSolarPanels;
import com.chocohead.nuclearcontrol.tiles.gui.elements.ColourBoxArray;
import ic2.api.network.ClientModifiable;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.upgrade.IUpgradableBlock;
import ic2.api.upgrade.UpgradableProperty;
import ic2.core.ContainerBase;
import ic2.core.GuiIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Redstone;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.gui.GuiElement;
import ic2.core.gui.Image;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.DynamicGui;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.init.Localization;
import ic2.core.network.GuiSynced;
import ic2.core.network.NetworkManager;
import ic2.core.util.Ic2Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFakeTeleporter
extends TileEntityInventory
implements IHasGui,
INetworkClientTileEntityEventListener,
IUpgradableBlock {
    private static final Ic2Color[] colours = (Ic2Color[])Arrays.stream(EnumDyeColor.values()).map(Ic2Color::get).toArray(Ic2Color[]::new);
    private static final int[] colourMap = Arrays.stream(Ic2Color.values).mapToInt(colour -> colour.mcColor.func_176765_a()).toArray();
    protected final InvSlot upgrade = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 1);
    @GuiSynced
    public int xOffset;
    @GuiSynced
    public int yOffset;
    @GuiSynced
    public int zOffset;
    @GuiSynced
    public int xLength = 1;
    @GuiSynced
    public int yLength = 1;
    @GuiSynced
    public int zLength = 1;
    @GuiSynced
    public byte density = (byte)2;
    @GuiSynced
    @ClientModifiable
    protected Ic2Color colour = Ic2Color.blue;
    public double red = -1.0;
    public double green;
    public double blue = 1.0;

    public TileEntityFakeTeleporter() {
        ((Redstone)this.addComponent((TileEntityComponent)new Redstone((TileEntityBlock)this))).subscribe(newLevel -> this.setActive(newLevel > 0));
    }

    public void setActive(boolean active) {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            super.setActive(active);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.xOffset = nbt.func_74762_e("xOffset");
        this.yOffset = nbt.func_74762_e("yOffset");
        this.zOffset = nbt.func_74762_e("zOffset");
        this.xLength = nbt.func_74762_e("xLength");
        this.yLength = nbt.func_74762_e("yLength");
        this.zLength = nbt.func_74762_e("zLength");
        this.density = nbt.func_74771_c("density");
        this.colour = Ic2Color.values[nbt.func_74771_c("colour")];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("xOffset", this.xOffset);
        nbt.func_74768_a("yOffset", this.yOffset);
        nbt.func_74768_a("zOffset", this.zOffset);
        nbt.func_74768_a("xLength", this.xLength);
        nbt.func_74768_a("yLength", this.yLength);
        nbt.func_74768_a("zLength", this.zLength);
        nbt.func_74774_a("density", this.density);
        nbt.func_74774_a("colour", (byte)this.colour.getId());
        return nbt;
    }

    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        this.xOffset = facing.func_82601_c();
        this.yOffset = facing.func_96559_d();
        this.zOffset = facing.func_82599_e();
    }

    protected void onLoaded() {
        super.onLoaded();
        if (this.field_145850_b.field_72995_K) {
            this.calculateColours();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void calculateColours() {
        switch (this.colour) {
            case black: {
                this.red = 0.01;
                this.blue = 0.0;
                this.green = 0.0;
                break;
            }
            case red: {
                this.red = 1.0;
                this.blue = 0.0;
                this.green = 0.0;
                break;
            }
            case green: {
                this.red = 0.01;
                this.green = 0.5;
                this.blue = 0.0;
                break;
            }
            case brown: {
                this.red = 0.5;
                this.green = 0.25;
                this.blue = 0.0;
                break;
            }
            case blue: {
                this.red = 0.01;
                this.green = 0.0;
                this.blue = 1.0;
                break;
            }
            case purple: {
                this.blue = 0.5;
                this.red = 0.5;
                this.green = 0.0;
                break;
            }
            case cyan: {
                this.red = 0.01;
                this.blue = 1.0;
                this.green = 1.0;
                break;
            }
            case light_gray: {
                this.blue = 0.6;
                this.green = 0.6;
                this.red = 0.6;
                break;
            }
            case gray: {
                this.blue = 0.3;
                this.green = 0.3;
                this.red = 0.3;
                break;
            }
            case pink: {
                this.red = 1.0;
                this.blue = 0.5;
                this.green = 0.5;
                break;
            }
            case lime: {
                this.red = 0.01;
                this.green = 1.0;
                this.blue = 0.0;
                break;
            }
            case yellow: {
                this.green = 1.0;
                this.red = 1.0;
                this.blue = 0.0;
                break;
            }
            case light_blue: {
                this.red = 0.01;
                this.green = 0.75;
                this.blue = 1.0;
                break;
            }
            case magenta: {
                this.blue = 1.0;
                this.red = 1.0;
                this.green = 0.0;
                break;
            }
            case orange: {
                this.red = 1.0;
                this.green = 0.5;
                this.blue = 0.0;
                break;
            }
            case white: {
                this.blue = 1.0;
                this.green = 1.0;
                this.red = 1.0;
                break;
            }
            default: {
                AdvancedSolarPanels.log.warn("Unexpected colour: " + this.colour);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive()) {
            Random rnd = this.field_145850_b.field_73012_v;
            for (int x = 0; x < this.xLength; ++x) {
                for (int y = 0; y < this.yLength; ++y) {
                    for (int z = 0; z < this.zLength; ++z) {
                        for (byte i = 0; i < this.density; i = (byte)(i + 1)) {
                            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, (double)((float)(this.field_174879_c.func_177958_n() + this.xOffset + x) + rnd.nextFloat()), (double)((float)(this.field_174879_c.func_177956_o() + this.yOffset + y) + rnd.nextFloat()), (double)((float)(this.field_174879_c.func_177952_p() + this.zOffset + z) + rnd.nextFloat()), this.red, this.green, this.blue, new int[0]);
                        }
                    }
                }
            }
        }
    }

    public List<String> getNetworkedFields() {
        List out = super.getNetworkedFields();
        out.add("xOffset");
        out.add("yOffset");
        out.add("zOffset");
        out.add("xLength");
        out.add("yLength");
        out.add("zLength");
        out.add("density");
        out.add("colour");
        return out;
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        DynamicGui gui = DynamicGui.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
        int y = 95;
        ResourceLocation edges = new ResourceLocation("tri_addon", "textures/gui/edges.png");
        gui.addElement((GuiElement)Image.create((GuiIC2)gui, (int)-27, (int)91, (int)30, (int)23, (ResourceLocation)edges, (int)256, (int)256, (int)1, (int)1, (int)31, (int)24));
        gui.addElement((GuiElement)Image.create((GuiIC2)gui, (int)173, (int)91, (int)30, (int)23, (ResourceLocation)edges, (int)256, (int)256, (int)1, (int)26, (int)31, (int)49));
        gui.addElement((GuiElement)new ColourBoxArray((GuiIC2<?>)gui, -24, 95, 0, colours).withSelected(colourMap[this.colour.getId()]).withChangeHandler((old, now) -> {
            this.colour = now.getColour();
            ((NetworkManager)IC2.network.get(false)).updateTileEntityField((TileEntity)this, "colour");
            this.calculateColours();
        }).withBoxTooltipHandler(box -> Collections.singletonList(Localization.translate((String)("tri_addon." + box.getColour().getName())))));
        return gui;
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public boolean getGuiState(String name) {
        switch (name) {
            case "xLength_shift": {
                return TileEntityFakeTeleporter.isShifting() && this.xLength > 1;
            }
            case "xLength_noShift": {
                return !TileEntityFakeTeleporter.isShifting() && this.xLength > 1;
            }
            case "yLength_shift": {
                return TileEntityFakeTeleporter.isShifting() && this.yLength > 1;
            }
            case "yLength_noShift": {
                return !TileEntityFakeTeleporter.isShifting() && this.yLength > 1;
            }
            case "zLength_shift": {
                return TileEntityFakeTeleporter.isShifting() && this.zLength > 1;
            }
            case "zLength_noShift": {
                return !TileEntityFakeTeleporter.isShifting() && this.zLength > 1;
            }
            case "min_density": {
                return this.density > 1;
            }
            case "max_density": {
                return this.density < 255;
            }
        }
        return super.getGuiState(name);
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean isShifting() {
        return GuiScreen.func_146272_n();
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        block0 : switch (event / 10) {
            case 0: {
                switch (event % 10) {
                    case 0: {
                        --this.xOffset;
                        break block0;
                    }
                    case 1: {
                        ++this.xOffset;
                        break block0;
                    }
                    case 2: {
                        this.xOffset -= 5;
                        break block0;
                    }
                    case 3: {
                        this.xOffset += 5;
                        break block0;
                    }
                }
                AdvancedSolarPanels.log.warn("Unexpected event given: " + event + " from " + player + " (" + (player != null ? player.func_70005_c_() : "unknown") + ')');
                break;
            }
            case 1: {
                switch (event % 10) {
                    case 0: {
                        --this.yOffset;
                        break block0;
                    }
                    case 1: {
                        ++this.yOffset;
                        break block0;
                    }
                    case 2: {
                        this.yOffset -= 5;
                        break block0;
                    }
                    case 3: {
                        this.yOffset += 5;
                        break block0;
                    }
                }
                AdvancedSolarPanels.log.warn("Unexpected event given: " + event + " from " + player + " (" + (player != null ? player.func_70005_c_() : "unknown") + ')');
                break;
            }
            case 2: {
                switch (event % 10) {
                    case 0: {
                        --this.zOffset;
                        break block0;
                    }
                    case 1: {
                        ++this.zOffset;
                        break block0;
                    }
                    case 2: {
                        this.zOffset -= 5;
                        break block0;
                    }
                    case 3: {
                        this.zOffset += 5;
                        break block0;
                    }
                }
                AdvancedSolarPanels.log.warn("Unexpected event given: " + event + " from " + player + " (" + (player != null ? player.func_70005_c_() : "unknown") + ')');
                break;
            }
            case 3: {
                switch (event % 10) {
                    case 0: {
                        assert (this.xLength > 1);
                        --this.xLength;
                        break block0;
                    }
                    case 1: {
                        ++this.xLength;
                        break block0;
                    }
                    case 2: {
                        this.xLength = Math.max(this.xLength - 5, 1);
                        break block0;
                    }
                    case 3: {
                        this.xLength += 5;
                        break block0;
                    }
                }
                AdvancedSolarPanels.log.warn("Unexpected event given: " + event + " from " + player + " (" + (player != null ? player.func_70005_c_() : "unknown") + ')');
                break;
            }
            case 4: {
                switch (event % 10) {
                    case 0: {
                        assert (this.yLength > 1);
                        --this.yLength;
                        break block0;
                    }
                    case 1: {
                        ++this.yLength;
                        break block0;
                    }
                    case 2: {
                        this.yLength = Math.max(this.yLength - 5, 1);
                        break block0;
                    }
                    case 3: {
                        this.yLength += 5;
                        break block0;
                    }
                }
                AdvancedSolarPanels.log.warn("Unexpected event given: " + event + " from " + player + " (" + (player != null ? player.func_70005_c_() : "unknown") + ')');
                break;
            }
            case 5: {
                switch (event % 10) {
                    case 0: {
                        assert (this.zLength > 1);
                        --this.zLength;
                        break block0;
                    }
                    case 1: {
                        ++this.zLength;
                        break block0;
                    }
                    case 2: {
                        this.zLength = Math.max(this.zLength - 5, 1);
                        break block0;
                    }
                    case 3: {
                        this.zLength += 5;
                        break block0;
                    }
                }
                AdvancedSolarPanels.log.warn("Unexpected event given: " + event + " from " + player + " (" + (player != null ? player.func_70005_c_() : "unknown") + ')');
                break;
            }
            case 6: {
                switch (event % 10) {
                    case 0: {
                        assert (this.density > 1);
                        this.density = (byte)(this.density - 1);
                        break block0;
                    }
                    case 1: {
                        assert (this.density <= 254);
                        this.density = (byte)(this.density + 1);
                        break block0;
                    }
                    case 2: {
                        this.density = (byte)Math.max(this.density - 5, 1);
                        break block0;
                    }
                    case 3: {
                        this.density = (byte)Math.min(this.density + 5, 255);
                        break block0;
                    }
                }
                AdvancedSolarPanels.log.warn("Unexpected event given: " + event + " from " + player + " (" + (player != null ? player.func_70005_c_() : "unknown") + ')');
                break;
            }
        }
    }

    public String particleNumber() {
        return Localization.translate((String)"tri_addon.machines.fake_teleporter.particles", (Object[])new Object[]{this.xLength * this.yLength * this.zLength * this.density});
    }

    public double getEnergy() {
        return 0.0;
    }

    public boolean useEnergy(double amount) {
        return false;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return Collections.singleton(UpgradableProperty.RedstoneSensitive);
    }
}

