/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.gravisuite.items;

import com.chocohead.gravisuite.Gravisuite;
import com.google.common.base.CaseFormat;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.init.BlocksItems;
import ic2.core.init.Localization;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAdvancedChainsaw
extends ItemElectricTool {
    protected static final String NAME = "advancedChainsaw";

    public ItemAdvancedChainsaw() {
        super(null, 100, ItemElectricTool.HarvestLevel.Iron, EnumSet.of(ItemElectricTool.ToolClass.Axe, ItemElectricTool.ToolClass.Sword, ItemElectricTool.ToolClass.Shears));
        ((ItemAdvancedChainsaw)BlocksItems.registerItem((Item)this, (ResourceLocation)new ResourceLocation("gravisuite", NAME))).func_77655_b(NAME);
        this.maxCharge = 45000;
        this.transferLimit = 500;
        this.tier = 2;
        this.field_77864_a = 30.0f;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(ItemName name) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("gravisuite:" + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, NAME), null));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && IC2.keyboard.isModeSwitchKeyDown(player)) {
            ItemStack stack = StackUtil.get((EntityPlayer)player, (EnumHand)hand);
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            if (nbt.func_74767_n("disableShear")) {
                nbt.func_74757_a("disableShear", false);
                Gravisuite.messagePlayer(player, "gravisuite.advancedChainsaw.shear", TextFormatting.DARK_GREEN, Localization.translate((String)"gravisuite.message.on"));
            } else {
                nbt.func_74757_a("disableShear", true);
                Gravisuite.messagePlayer(player, "gravisuite.advancedChainsaw.shear", TextFormatting.DARK_RED, Localization.translate((String)"gravisuite.message.off"));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        ElectricItem.manager.use(stack, this.operationEnergyCost, attacker);
        if (attacker instanceof EntityPlayer && target instanceof EntityCreeper && target.func_110143_aJ() <= 0.0f) {
            IC2.achievements.issueAchievement((EntityPlayer)attacker, "killCreeperChainsaw");
        }
        return true;
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        BlockPos pos;
        IShearable target;
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        Entity entity = event.getTarget();
        ItemStack stack = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
        if (stack != null && stack.func_77973_b() == this && entity instanceof IShearable && !StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n("disableShear") && ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)player) && (target = (IShearable)entity).isShearable(stack, (IBlockAccess)entity.field_70170_p, pos = new BlockPos(entity))) {
            List drops = target.onSheared(stack, (IBlockAccess)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
            for (ItemStack drop : drops) {
                EntityItem item = entity.func_70099_a(drop, 1.0f);
                item.field_70181_x += (double)(field_77697_d.nextFloat() * 0.05f);
                item.field_70159_w += (double)((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f);
                item.field_70179_y += (double)((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f);
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        IShearable target;
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return false;
        }
        if (StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n("disableShear")) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(stack, (IBlockAccess)world, pos) && ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)player)) {
            List drops = target.onSheared(stack, (IBlockAccess)world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
            for (ItemStack drop : drops) {
                StackUtil.dropAsEntity((World)world, (BlockPos)pos, (ItemStack)drop);
            }
            player.func_71064_a(StatList.func_188055_a((Block)block), 1);
        }
        return false;
    }

    public String func_77658_a() {
        return "gravisuite." + super.func_77658_a().substring(4);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n("disableShear")) {
            tooltip.add(TextFormatting.DARK_RED + Localization.translate((String)"gravisuite.advancedChainsaw.shear", (Object[])new Object[]{Localization.translate((String)"gravisuite.message.off")}));
        } else {
            tooltip.add(TextFormatting.DARK_GREEN + Localization.translate((String)"gravisuite.advancedChainsaw.shear", (Object[])new Object[]{Localization.translate((String)"gravisuite.message.on")}));
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        if (slot != EntityEquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(slot, stack);
        }
        HashMultimap ret = HashMultimap.create();
        if (ElectricItem.manager.canUse(stack, this.operationEnergyCost)) {
            ret.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.field_185065_c, 0));
            ret.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(Item.field_111210_e, "Tool modifier", 13.0, 0));
        }
        return ret;
    }

    protected String getIdleSound(EntityLivingBase player, ItemStack stack) {
        return "Tools/Chainsaw/ChainsawIdle.ogg";
    }

    protected String getStopSound(EntityLivingBase player, ItemStack stack) {
        return "Tools/Chainsaw/ChainsawStop.ogg";
    }
}

