/*
 * Decompiled with CFR 0.152.
 */
package fruitmods.armourhud;

import fruitmods.armourhud.ArmourHUD_KeyHandler;
import fruitmods.armourhud.ArmourHUD_ticker;
import fruitmods.fruitlibs.mod_FruitLibs;
import java.util.TreeMap;
import java.util.logging.Logger;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="armourhud", name="Armour HUD", version="3.2", dependencies="required-after:fruitmods_fruitlibs@[1.6,)", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
@SideOnly(value=Side.CLIENT)
public class ArmourHUD {
    public static final String MODID = "armourhud";
    public static final String MOD_NAME = "Armour HUD";
    public static final String VERSION = "3.2";
    @Mod.Instance(value="ArmourHUD")
    public static ArmourHUD instance;
    public static Logger log;
    public static boolean is_IC2_installed;
    public static boolean is_TE_installed;
    public static int HUD_position;
    public static boolean show_schematic;
    public static boolean show_text;
    public static boolean always_percentages;
    public static float HUD_size_percentage;
    public static float HUD_text_percentage;
    public static float HUD_colour_saturation;
    public static float HUD_maximum_hue;
    public static float HUD_background_alpha;
    public static float HUD_armour_alpha;
    public static float HUD_text_alpha;
    static Configuration armour_HUD_config;
    public static TreeMap<String, String> item_abbreviations;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        armour_HUD_config = new Configuration(event.getSuggestedConfigurationFile());
        armour_HUD_config.load();
        HUD_position = Integer.parseInt(armour_HUD_config.get("general", "HUD Position", 2).getString());
        if (HUD_position < 0 || HUD_position > 4) {
            HUD_position = 2;
        }
        show_schematic = Boolean.parseBoolean(armour_HUD_config.get("general", "Show HUD Schematic", false).getString());
        show_text = Boolean.parseBoolean(armour_HUD_config.get("general", "Show HUD Text", true).getString());
        always_percentages = Boolean.parseBoolean(armour_HUD_config.get("general", "Use Percentages instead of exact values", false).getString());
        HUD_text_percentage = (float)Integer.parseInt(armour_HUD_config.get("general", "HUD Text Size Percentage", 60).getString()) / 100.0f;
        if (HUD_text_percentage < 0.01f || HUD_text_percentage > 1.5f) {
            HUD_text_percentage = 0.75f;
        }
        if ((HUD_size_percentage = (float)Integer.parseInt(armour_HUD_config.get("general", "HUD Graphics Size Percentage", 60).getString()) / 100.0f) < 0.01f || HUD_size_percentage > 1.5f) {
            HUD_size_percentage = 1.0f;
        }
        if ((HUD_colour_saturation = (float)Integer.parseInt(armour_HUD_config.get("general", "HUD Colour Saturation", 70).getString()) / 100.0f) < 0.0f || HUD_colour_saturation > 1.0f) {
            HUD_colour_saturation = 1.0f;
        }
        if ((HUD_maximum_hue = (float)Integer.parseInt(armour_HUD_config.get("general", "HUD Maximum Hue", 240).getString())) < 1.0f || HUD_maximum_hue > 360.0f) {
            HUD_maximum_hue = 240.0f;
        }
        if ((HUD_background_alpha = (float)Integer.parseInt(armour_HUD_config.get("general", "HUD Background Opacity", 50).getString()) / 100.0f) < 0.0f || HUD_background_alpha > 1.0f) {
            HUD_background_alpha = 0.5f;
        }
        if ((HUD_armour_alpha = (float)Integer.parseInt(armour_HUD_config.get("general", "HUD Graphics Opacity", 60).getString()) / 100.0f) < 0.0f || HUD_armour_alpha > 1.0f) {
            HUD_armour_alpha = 0.6f;
        }
        if ((HUD_text_alpha = (float)Integer.parseInt(armour_HUD_config.get("general", "HUD Text Opacity", 90).getString()) / 100.0f) < 0.0f || HUD_text_alpha > 1.0f) {
            HUD_text_alpha = 0.9f;
        }
        armour_HUD_config.save();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        try {
            Class.forName("ic2.core.IC2");
            log.info("IndustrialCraft 2 detected.");
        }
        catch (ClassNotFoundException e) {
            log.info("IndustrialCraft 2 not detected.");
            is_IC2_installed = false;
        }
        try {
            Class.forName("cofh.redstoneflux.api.IEnergyContainerItem");
            log.info("Thermal Expansion detected.");
        }
        catch (ClassNotFoundException e) {
            log.info("Thermal Expansion not detected.");
            is_TE_installed = false;
        }
        FMLCommonHandler.instance().bus().register((Object)new ArmourHUD_KeyHandler());
        FMLCommonHandler.instance().bus().register((Object)new ArmourHUD_ticker(mod_FruitLibs.getDisplayLib()));
    }

    public static String loadAbbreviatedItemName(String item_name) {
        for (int i = 0; i < item_name.length(); ++i) {
            if ((Character.isLetterOrDigit(item_name.charAt(i)) || Character.isWhitespace(item_name.charAt(i))) && item_name.charAt(i) <= '\u00ff') continue;
            return item_name;
        }
        if (item_name == null || item_name == "" || item_name.isEmpty()) {
            return "Unknown";
        }
        armour_HUD_config.load();
        String CATEGORY_ABBREVIATIONS = "abbreviations";
        String temp_item_abbreviation = armour_HUD_config.get(CATEGORY_ABBREVIATIONS, item_name, item_name).getString();
        armour_HUD_config.save();
        return temp_item_abbreviation;
    }

    public static void cycleHUDPosition() {
        HUD_position = HUD_position == 0 ? 1 : (HUD_position == 1 ? 2 : (HUD_position == 2 ? 3 : (HUD_position == 3 ? 4 : 0)));
        armour_HUD_config.load();
        Property HUD_pos_prop = armour_HUD_config.get("general", "HUD Position", 1);
        HUD_pos_prop.set(Integer.toString(HUD_position));
        armour_HUD_config.save();
    }

    static {
        log = Logger.getLogger(MOD_NAME);
        is_IC2_installed = true;
        is_TE_installed = true;
        item_abbreviations = new TreeMap();
    }
}

