/*
 * Decompiled with CFR 0.152.
 */
package fruitmods.fruitlibs;

import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;

public class FruitDisplayLib {
    private static final ResourceLocation[] unicodePageLocations = new ResourceLocation[256];
    public byte[] glyphWidth = new byte[65536];
    private final TextureManager renderEngine;

    public FruitDisplayLib(TextureManager supplied_render_engine) {
        this.renderEngine = supplied_render_engine;
        this.readGlyphSizes();
    }

    private void readGlyphSizes() {
        try {
            InputStream inputstream = FMLClientHandler.instance().getClient().func_110442_L().func_110536_a(new ResourceLocation("font/glyph_sizes.bin")).func_110527_b();
            inputstream.read(this.glyphWidth);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
    }

    public String getVersion() {
        return "1.6";
    }

    private ResourceLocation getUnicodePageLocation(int page) {
        if (unicodePageLocations[page] == null) {
            FruitDisplayLib.unicodePageLocations[page] = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", page));
        }
        return unicodePageLocations[page];
    }

    private void loadGlyphTexture(int page) {
        this.renderEngine.func_110577_a(this.getUnicodePageLocation(page));
    }

    public float renderScaledUnicodeChar(char unicode_char, float posX, float posY, float font_scaling, float[] RGBarray, float alpha) {
        if (this.glyphWidth[unicode_char] == 0) {
            return 0.0f;
        }
        if (unicode_char == ' ') {
            return 4.0f * font_scaling;
        }
        GlStateManager.func_179131_c((float)RGBarray[0], (float)RGBarray[1], (float)RGBarray[2], (float)alpha);
        int glyph_page = unicode_char / 256;
        this.loadGlyphTexture(glyph_page);
        int upper_width_nibble = this.glyphWidth[unicode_char] >>> 4;
        int lower_width_nibble = this.glyphWidth[unicode_char] & 0xF;
        float f = upper_width_nibble;
        float f1 = (float)lower_width_nibble + 1.0f;
        float f2 = (float)(unicode_char % 16 * 16) + f;
        float f3 = (unicode_char & 0xFF) / 16 * 16;
        float f4 = f1 - f - 0.02f;
        GlStateManager.func_187447_r((int)5);
        GlStateManager.func_187426_b((float)(f2 / 256.0f), (float)(f3 / 256.0f));
        GlStateManager.func_187435_e((float)posX, (float)posY, (float)0.0f);
        GlStateManager.func_187426_b((float)(f2 / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GlStateManager.func_187435_e((float)posX, (float)(posY + 7.99f * font_scaling), (float)0.0f);
        GlStateManager.func_187426_b((float)((f2 + f4) / 256.0f), (float)(f3 / 256.0f));
        GlStateManager.func_187435_e((float)(posX + f4 / 2.0f * font_scaling), (float)posY, (float)0.0f);
        GlStateManager.func_187426_b((float)((f2 + f4) / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GlStateManager.func_187435_e((float)(posX + f4 / 2.0f * font_scaling), (float)(posY + 7.99f * font_scaling), (float)0.0f);
        GlStateManager.func_187437_J();
        return ((f1 - f) / 2.0f + 1.3f) * font_scaling;
    }

    public void renderScaledStringAtPos(String input, float xstart, float ystart, float font_scaling, float[] RGBarray, float alpha, boolean hasShadow) {
        float writing_pos = xstart;
        float writing_offset = 0.0f;
        for (int i = 0; i < input.length(); ++i) {
            writing_offset = this.renderScaledUnicodeChar(input.charAt(i), writing_pos, ystart, font_scaling, RGBarray, alpha);
            writing_pos += writing_offset;
        }
    }

    public void drawShadedRect(float xpos, float ypos, float xsize, float ysize, float[] RGBarray, float alpha) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tess.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b((double)xpos, (double)ypos, 0.0).func_181666_a(RGBarray[0], RGBarray[1], RGBarray[2], alpha).func_181675_d();
        bufferBuilder.func_181662_b((double)xpos, (double)(ypos + ysize), 0.0).func_181666_a(RGBarray[0], RGBarray[1], RGBarray[2], alpha).func_181675_d();
        bufferBuilder.func_181662_b((double)(xpos + xsize), (double)(ypos + ysize), 0.0).func_181666_a(RGBarray[0], RGBarray[1], RGBarray[2], alpha).func_181675_d();
        bufferBuilder.func_181662_b((double)(xpos + xsize), (double)ypos, 0.0).func_181666_a(RGBarray[0], RGBarray[1], RGBarray[2], alpha).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public void drawHollowRect(float xpos, float ypos, float xsize, float ysize, float thickness, float[] RGBarray, float alpha) {
        this.drawShadedRect(xpos, ypos, xsize - thickness, thickness, RGBarray, alpha);
        this.drawShadedRect(xpos + xsize - thickness, ypos, thickness, ysize - thickness, RGBarray, alpha);
        this.drawShadedRect(xpos + thickness, ypos + ysize - thickness, xsize - thickness, thickness, RGBarray, alpha);
        this.drawShadedRect(xpos, ypos + thickness, thickness, ysize - thickness, RGBarray, alpha);
    }

    public float[] HSVtoRGB(float hue, float saturation, float value) {
        float[] result = new float[]{1.0f, 1.0f, 1.0f};
        if (hue == -1.0f) {
            return result;
        }
        if (hue == 0.0f) {
            result[0] = 0.0f;
            result[1] = 0.0f;
            result[2] = 0.0f;
            return result;
        }
        float chroma = value * saturation;
        float hue_prime = hue / 60.0f;
        float alt_component = chroma * (1.0f - Math.abs(hue_prime % 2.0f - 1.0f));
        float value_match = value - chroma;
        boolean isValidColour = true;
        if (0.0f <= hue_prime && hue_prime < 1.0f) {
            result[0] = chroma;
            result[1] = alt_component;
            result[2] = 0.0f;
        } else if (1.0f <= hue_prime && hue_prime < 2.0f) {
            result[0] = alt_component;
            result[1] = chroma;
            result[2] = 0.0f;
        } else if (2.0f <= hue_prime && hue_prime < 3.0f) {
            result[0] = 0.0f;
            result[1] = chroma;
            result[2] = alt_component;
        } else if (3.0f <= hue_prime && hue_prime < 4.0f) {
            result[0] = 0.0f;
            result[1] = alt_component;
            result[2] = chroma;
        } else if (4.0f <= hue_prime && hue_prime < 5.0f) {
            result[0] = alt_component;
            result[1] = 0.0f;
            result[2] = chroma;
        } else if (5.0f <= hue_prime && hue_prime < 6.0f) {
            result[0] = chroma;
            result[1] = 0.0f;
            result[2] = alt_component;
        } else {
            isValidColour = false;
        }
        if (isValidColour) {
            for (int i = 0; i < 3; ++i) {
                result[i] = result[i] + value_match;
            }
        }
        return result;
    }

    public float getStringWidth(String string_to_measure) {
        if (string_to_measure == null) {
            return 0.0f;
        }
        float var2 = 0.0f;
        boolean var3 = false;
        for (int var4 = 0; var4 < string_to_measure.length(); ++var4) {
            char var5 = string_to_measure.charAt(var4);
            float var6 = this.getCharWidth(var5);
            if (var6 < 0.0f && var4 < string_to_measure.length() - 1) {
                if ((var5 = string_to_measure.charAt(++var4)) != 'l' && var5 != 'L') {
                    if (var5 == 'r' || var5 == 'R') {
                        var3 = false;
                    }
                } else {
                    var3 = true;
                }
                var6 = this.getCharWidth(var5);
            }
            var2 += var6;
            if (!var3) continue;
            var2 += 1.0f;
        }
        return var2;
    }

    public float getCharWidth(char char_to_measure) {
        if (char_to_measure == '\u00a7') {
            return -1.0f;
        }
        if (char_to_measure == ' ') {
            return 4.0f;
        }
        if (this.glyphWidth[char_to_measure] != 0) {
            int j = this.glyphWidth[char_to_measure] >>> 4;
            int k = this.glyphWidth[char_to_measure] & 0xF;
            if (k > 7) {
                k = 15;
                j = 0;
            }
            return (float)(++k - j) / 2.0f + 1.3f;
        }
        return 0.0f;
    }
}

