/*
 * Decompiled with CFR 0.152.
 */
package fruitmods.armourhud;

import cofh.redstoneflux.api.IEnergyContainerItem;
import fruitmods.api.armourhud.IArmourHUDProperties;
import fruitmods.armourhud.ArmourHUD;
import fruitmods.armourhud.GearInfoContainer;
import fruitmods.fruitlibs.FruitDisplayLib;
import ic2.api.item.IElectricItem;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ArmourHUD_ticker {
    private Minecraft minecraft = FMLClientHandler.instance().getClient();
    private FruitDisplayLib hud_drawing_engine;
    private float hat_string_width = 0.0f;
    private float shirt_string_width = 0.0f;
    private float trousers_string_width = 0.0f;
    private float shoes_string_width = 0.0f;
    private float tool_string_width = 0.0f;
    DecimalFormat armour_percent = new DecimalFormat("###.#");
    DecimalFormat coarse_armour_percent = new DecimalFormat("###");
    ItemStack hat;
    ItemStack shirt;
    ItemStack trousers;
    ItemStack shoes;
    ItemStack tool;
    private static int disp_width;
    private static int disp_height;
    private float x_offset;
    private float y_offset;
    private float armour_x_centre;
    private float armour_width;
    private float armour_height;
    private float bodypart_spacing;
    private float border_spacing;
    private float head_width;
    private float torso_width;
    private float torso_height;
    private float torso_ypos;
    private float arm_width;
    private float arm_height;
    private float leg_width;
    private float leg_height;
    private float left_leg_xcentre;
    private float right_leg_xcentre;
    private float shoe_width;
    private float shoe_height;
    private float shoe_ypos;
    private float box_border_spacing = 2.0f;
    private float graphical_text_scaling;
    private float graphical_text_xpos;
    private float graphical_text_ypos;

    public ArmourHUD_ticker(FruitDisplayLib fruitdisplaylib) {
        this.hud_drawing_engine = fruitdisplaylib;
    }

    private GearInfoContainer gearInfo(ItemStack gear) {
        GearInfoContainer gear_info = new GearInfoContainer();
        float currentValue = 0.0f;
        float maxValue = 0.0f;
        if (gear != null && gear.func_77973_b() != Items.field_190931_a) {
            gear_info.name = gear.func_82833_r() + "";
            if (gear_info.name == null || gear_info.name == "") {
                gear_info.name = "Unknown";
            } else {
                int j = gear_info.name.length();
                for (int i = 0; i < j; ++i) {
                    String temp1;
                    if (gear_info.name.charAt(i) != '\u00a7') continue;
                    if (i + 1 < gear_info.name.length()) {
                        temp1 = gear_info.name.substring(0, i);
                        String temp2 = gear_info.name.substring(i + 2, gear_info.name.length());
                        gear_info.name = temp1 + temp2;
                        j = gear_info.name.length();
                        continue;
                    }
                    gear_info.name = temp1 = gear_info.name.substring(0, i);
                    j = gear_info.name.length();
                }
                if (ArmourHUD.item_abbreviations.containsKey(gear_info.name)) {
                    gear_info.name = ArmourHUD.item_abbreviations.get(gear_info.name);
                } else {
                    ArmourHUD.item_abbreviations.put(gear_info.name, ArmourHUD.loadAbbreviatedItemName(gear_info.name));
                }
            }
            if (ArmourHUD.is_IC2_installed && gear.func_77973_b() instanceof IElectricItem) {
                IElectricItem temp_gear = (IElectricItem)gear.func_77973_b();
                maxValue = (float)temp_gear.getMaxCharge(gear);
                if (maxValue != 0.0f) {
                    currentValue = gear.func_77942_o() && gear.func_77978_p().func_74764_b("charge") ? (float)gear.func_77978_p().func_74762_e("charge") : 0.0f;
                    gear_info.fraction = currentValue == 0.0f ? 0.0f : currentValue / maxValue;
                    gear_info.name = gear_info.name + ": ";
                    gear_info.value = ArmourHUD.always_percentages ? this.armour_percent.format(gear_info.fraction * 100.0f) + "%" : Float.toString(currentValue) + "/" + Float.toString(maxValue) + " EU";
                }
            } else if (ArmourHUD.is_TE_installed && gear.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem temp_gear = (IEnergyContainerItem)gear.func_77973_b();
                currentValue = temp_gear.getEnergyStored(gear);
                maxValue = temp_gear.getMaxEnergyStored(gear);
                if (maxValue != 0.0f) {
                    gear_info.fraction = currentValue == 0.0f ? 0.0f : currentValue / maxValue;
                    gear_info.name = gear_info.name + ": ";
                    gear_info.value = ArmourHUD.always_percentages ? this.armour_percent.format(gear_info.fraction * 100.0f) + "%" : Float.toString(currentValue) + "/" + Float.toString(maxValue) + " RF";
                }
            } else if (gear.func_77973_b() instanceof IEnergyStorage) {
                IEnergyStorage temp_gear = (IEnergyStorage)gear.func_77973_b();
                currentValue = temp_gear.getEnergyStored();
                maxValue = temp_gear.getMaxEnergyStored();
                if (maxValue != 0.0f) {
                    gear_info.fraction = currentValue == 0.0f ? 0.0f : currentValue / maxValue;
                    gear_info.name = gear_info.name + ": ";
                    gear_info.value = ArmourHUD.always_percentages ? this.armour_percent.format(gear_info.fraction * 100.0f) + "%" : Float.toString(currentValue) + "/" + Float.toString(maxValue) + " FE";
                }
            } else if (gear.func_77942_o() && gear.func_77978_p().func_74764_b("InfiTool")) {
                gear_info.name = gear_info.name + ": ";
                int damage = gear.func_77978_p().func_74775_l("InfiTool").func_74762_e("Damage");
                int durability = gear.func_77978_p().func_74775_l("InfiTool").func_74762_e("TotalDurability");
                gear_info.fraction = (float)(durability - damage) / (float)durability;
                gear_info.value = ArmourHUD.always_percentages ? this.armour_percent.format(gear_info.fraction * 100.0f) + "%" : Integer.toString(durability - damage) + "/" + Integer.toString(durability);
            } else if (gear.func_77973_b().func_77645_m()) {
                gear_info.name = gear_info.name + ": ";
                gear_info.fraction = (float)(gear.func_77958_k() - gear.func_77952_i()) / (float)gear.func_77958_k();
                gear_info.value = ArmourHUD.always_percentages ? this.armour_percent.format(gear_info.fraction * 100.0f) + "%" : Integer.toString(gear.func_77958_k() - gear.func_77952_i()) + "/" + Integer.toString(gear.func_77958_k());
            } else if (gear.func_77973_b().func_77639_j() > 1) {
                gear_info.prefix = Integer.toString(gear.func_190916_E()) + "x ";
            } else {
                gear_info.fraction = 2.0f;
            }
        }
        return gear_info;
    }

    public void graphicalStatus(Minecraft minecraft, GearInfoContainer[] gear_infos) {
        if (ArmourHUD.show_schematic) {
            this.hud_drawing_engine.drawShadedRect(this.x_offset, this.y_offset, this.armour_width, this.armour_height, this.hud_drawing_engine.HSVtoRGB(0.0f, 0.0f, 0.0f), ArmourHUD.HUD_background_alpha);
        }
        if (this.hat != null) {
            if (ArmourHUD.show_schematic) {
                this.hud_drawing_engine.drawShadedRect(this.armour_x_centre - this.head_width / 2.0f, this.torso_ypos - this.bodypart_spacing - this.head_width, this.head_width, this.head_width, this.hud_drawing_engine.HSVtoRGB(gear_infos[0].fraction * ArmourHUD.HUD_maximum_hue, 1.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                if (gear_infos[0].active) {
                    this.hud_drawing_engine.drawHollowRect(this.armour_x_centre - this.head_width / 2.0f, this.torso_ypos - this.bodypart_spacing - this.head_width, this.head_width, this.head_width, 2.0f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                }
            }
            if (ArmourHUD.HUD_position == 0) {
                this.graphical_text_xpos = this.box_border_spacing + this.armour_width + this.armour_width / 4.0f;
                this.graphical_text_ypos = this.y_offset;
            } else if (ArmourHUD.HUD_position == 1) {
                this.graphical_text_xpos = (float)disp_width - this.box_border_spacing - this.armour_width - this.armour_width / 4.0f - this.hat_string_width;
                this.graphical_text_ypos = this.y_offset;
            } else if (ArmourHUD.HUD_position == 2) {
                this.graphical_text_xpos = this.box_border_spacing;
                this.graphical_text_ypos = this.y_offset - 30.0f * this.graphical_text_scaling;
            } else {
                this.graphical_text_xpos = (float)disp_width - this.box_border_spacing - this.hat_string_width;
                this.graphical_text_ypos = this.y_offset - 30.0f * this.graphical_text_scaling;
            }
            if (ArmourHUD.show_text) {
                this.hud_drawing_engine.drawShadedRect(this.graphical_text_xpos - 1.0f * this.graphical_text_scaling, this.graphical_text_ypos - 1.0f * this.graphical_text_scaling, this.hat_string_width + 2.0f * this.graphical_text_scaling, 10.0f * this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(0.0f, 0.0f, 0.0f), ArmourHUD.HUD_background_alpha);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[0].prefix, this.graphical_text_xpos, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[0].prefix_hue, gear_infos[0].prefix_saturation, gear_infos[0].prefix_luminosity), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[0].name, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[0].prefix) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(ArmourHUD.HUD_maximum_hue, 0.0f, 1.0f), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[0].value, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[0].prefix + gear_infos[0].name) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[0].fraction * ArmourHUD.HUD_maximum_hue, ArmourHUD.HUD_colour_saturation * 1.0f, 1.0f), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[0].postfix, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[0].prefix + gear_infos[0].name + gear_infos[0].value) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[0].postfix_hue, gear_infos[0].postfix_saturation, gear_infos[0].postfix_luminosity), ArmourHUD.HUD_text_alpha, false);
            }
        } else if (ArmourHUD.show_schematic) {
            this.hud_drawing_engine.drawHollowRect(this.armour_x_centre - this.head_width / 2.0f, this.torso_ypos - this.bodypart_spacing - this.head_width, this.head_width, this.head_width, 0.5f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
        }
        if (this.shirt != null) {
            if (ArmourHUD.show_schematic) {
                this.hud_drawing_engine.drawShadedRect(this.armour_x_centre - this.torso_width / 2.0f, this.torso_ypos, this.torso_width, this.torso_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[1].fraction * ArmourHUD.HUD_maximum_hue, 1.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                if (gear_infos[1].active) {
                    this.hud_drawing_engine.drawHollowRect(this.armour_x_centre - this.torso_width / 2.0f, this.torso_ypos, this.torso_width, this.torso_height, 2.0f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                }
            }
            if (ArmourHUD.HUD_position == 0) {
                this.graphical_text_xpos = this.box_border_spacing + this.armour_width + this.armour_width / 4.0f;
                this.graphical_text_ypos = this.y_offset + 15.0f * this.graphical_text_scaling;
            } else if (ArmourHUD.HUD_position == 1) {
                this.graphical_text_xpos = (float)disp_width - this.box_border_spacing - this.armour_width - this.armour_width / 4.0f - this.shirt_string_width;
                this.graphical_text_ypos = this.y_offset + 15.0f * this.graphical_text_scaling;
            } else if (ArmourHUD.HUD_position == 2) {
                this.graphical_text_xpos = this.box_border_spacing;
                this.graphical_text_ypos = this.y_offset - 15.0f * this.graphical_text_scaling;
            } else {
                this.graphical_text_xpos = (float)disp_width - this.box_border_spacing - this.shirt_string_width;
                this.graphical_text_ypos = this.y_offset - 15.0f * this.graphical_text_scaling;
            }
            if (ArmourHUD.show_text) {
                this.hud_drawing_engine.drawShadedRect(this.graphical_text_xpos - 1.0f * this.graphical_text_scaling, this.graphical_text_ypos - 1.0f * this.graphical_text_scaling, this.shirt_string_width + 2.0f * this.graphical_text_scaling, 10.0f * this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(0.0f, 0.0f, 0.0f), ArmourHUD.HUD_background_alpha);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[1].prefix, this.graphical_text_xpos, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[1].prefix_hue, gear_infos[1].prefix_saturation, gear_infos[1].prefix_luminosity), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[1].name, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[1].prefix) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(ArmourHUD.HUD_maximum_hue, 0.0f, 1.0f), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[1].value, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[1].prefix + gear_infos[1].name) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[1].fraction * ArmourHUD.HUD_maximum_hue, ArmourHUD.HUD_colour_saturation * 1.0f, 1.0f), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[1].postfix, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[1].prefix + gear_infos[1].name + gear_infos[1].value) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[1].postfix_hue, gear_infos[1].postfix_saturation, gear_infos[1].postfix_luminosity), ArmourHUD.HUD_text_alpha, false);
            }
        } else if (ArmourHUD.show_schematic) {
            this.hud_drawing_engine.drawHollowRect(this.armour_x_centre - this.torso_width / 2.0f, this.torso_ypos, this.torso_width, this.torso_height, 0.5f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
        }
        if (this.trousers != null) {
            if (ArmourHUD.show_schematic) {
                this.hud_drawing_engine.drawShadedRect(this.left_leg_xcentre - this.leg_width / 2.0f, this.torso_ypos + this.torso_height + this.bodypart_spacing, this.leg_width, this.leg_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[2].fraction * ArmourHUD.HUD_maximum_hue, 1.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                this.hud_drawing_engine.drawShadedRect(this.right_leg_xcentre - this.leg_width / 2.0f, this.torso_ypos + this.torso_height + this.bodypart_spacing, this.leg_width, this.leg_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[2].fraction * ArmourHUD.HUD_maximum_hue, 1.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                if (gear_infos[2].active) {
                    this.hud_drawing_engine.drawHollowRect(this.left_leg_xcentre - this.leg_width / 2.0f, this.torso_ypos + this.torso_height + this.bodypart_spacing, this.leg_width, this.leg_height, 2.0f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                    this.hud_drawing_engine.drawHollowRect(this.right_leg_xcentre - this.leg_width / 2.0f, this.torso_ypos + this.torso_height + this.bodypart_spacing, this.leg_width, this.leg_height, 2.0f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                }
            }
            if (ArmourHUD.HUD_position == 0) {
                this.graphical_text_xpos = this.box_border_spacing + this.armour_width + this.armour_width / 4.0f;
                this.graphical_text_ypos = this.y_offset + 45.0f * this.graphical_text_scaling;
            } else if (ArmourHUD.HUD_position == 1) {
                this.graphical_text_xpos = (float)disp_width - this.box_border_spacing - this.armour_width - this.armour_width / 4.0f - this.trousers_string_width;
                this.graphical_text_ypos = this.y_offset + 45.0f * this.graphical_text_scaling;
            } else if (ArmourHUD.HUD_position == 2) {
                this.graphical_text_xpos = this.box_border_spacing + this.armour_width + this.armour_width / 4.0f;
                this.graphical_text_ypos = this.y_offset + 15.0f * this.graphical_text_scaling;
            } else {
                this.graphical_text_xpos = (float)disp_width - this.box_border_spacing - this.armour_width - this.armour_width / 4.0f - this.trousers_string_width;
                this.graphical_text_ypos = this.y_offset + 15.0f * this.graphical_text_scaling;
            }
            if (ArmourHUD.show_text) {
                this.hud_drawing_engine.drawShadedRect(this.graphical_text_xpos - 1.0f * this.graphical_text_scaling, this.graphical_text_ypos - 1.0f * this.graphical_text_scaling, this.trousers_string_width + 2.0f * this.graphical_text_scaling, 10.0f * this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(0.0f, 0.0f, 0.0f), ArmourHUD.HUD_background_alpha);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[2].prefix, this.graphical_text_xpos, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[2].prefix_hue, gear_infos[2].prefix_saturation, gear_infos[2].prefix_luminosity), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[2].name, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[2].prefix) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(ArmourHUD.HUD_maximum_hue, 0.0f, 1.0f), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[2].value, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[2].prefix + gear_infos[2].name) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[2].fraction * ArmourHUD.HUD_maximum_hue, ArmourHUD.HUD_colour_saturation * 1.0f, 1.0f), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[2].postfix, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[2].prefix + gear_infos[2].name + gear_infos[2].value) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[2].postfix_hue, gear_infos[2].postfix_saturation, gear_infos[2].postfix_luminosity), ArmourHUD.HUD_text_alpha, false);
            }
        } else if (ArmourHUD.show_schematic) {
            this.hud_drawing_engine.drawHollowRect(this.left_leg_xcentre - this.leg_width / 2.0f, this.torso_ypos + this.torso_height + this.bodypart_spacing, this.leg_width, this.leg_height, 0.5f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
            this.hud_drawing_engine.drawHollowRect(this.right_leg_xcentre - this.leg_width / 2.0f, this.torso_ypos + this.torso_height + this.bodypart_spacing, this.leg_width, this.leg_height, 0.5f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
        }
        if (this.shoes != null) {
            if (ArmourHUD.show_schematic) {
                this.hud_drawing_engine.drawShadedRect(this.left_leg_xcentre - this.shoe_width / 2.0f, this.shoe_ypos, this.shoe_width, this.shoe_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[3].fraction * ArmourHUD.HUD_maximum_hue, 1.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                this.hud_drawing_engine.drawShadedRect(this.right_leg_xcentre - this.shoe_width / 2.0f, this.shoe_ypos, this.shoe_width, this.shoe_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[3].fraction * ArmourHUD.HUD_maximum_hue, 1.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                if (gear_infos[3].active) {
                    this.hud_drawing_engine.drawHollowRect(this.left_leg_xcentre - this.shoe_width / 2.0f, this.shoe_ypos, this.shoe_width, this.shoe_height, 2.0f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                    this.hud_drawing_engine.drawHollowRect(this.right_leg_xcentre - this.shoe_width / 2.0f, this.shoe_ypos, this.shoe_width, this.shoe_height, 2.0f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                }
            }
            if (ArmourHUD.HUD_position == 0) {
                this.graphical_text_xpos = this.box_border_spacing + this.armour_width + this.armour_width / 4.0f;
                this.graphical_text_ypos = this.y_offset + 60.0f * this.graphical_text_scaling;
            } else if (ArmourHUD.HUD_position == 1) {
                this.graphical_text_xpos = (float)disp_width - this.box_border_spacing - this.armour_width - this.armour_width / 4.0f - this.shoes_string_width;
                this.graphical_text_ypos = this.y_offset + 60.0f * this.graphical_text_scaling;
            } else if (ArmourHUD.HUD_position == 2) {
                this.graphical_text_xpos = this.box_border_spacing + this.armour_width + this.armour_width / 4.0f;
                this.graphical_text_ypos = this.y_offset + 30.0f * this.graphical_text_scaling;
            } else {
                this.graphical_text_xpos = (float)disp_width - this.box_border_spacing - this.armour_width - this.armour_width / 4.0f - this.shoes_string_width;
                this.graphical_text_ypos = this.y_offset + 30.0f * this.graphical_text_scaling;
            }
            if (ArmourHUD.show_text) {
                this.hud_drawing_engine.drawShadedRect(this.graphical_text_xpos - 1.0f * this.graphical_text_scaling, this.graphical_text_ypos - 1.0f * this.graphical_text_scaling, this.shoes_string_width + 2.0f * this.graphical_text_scaling, 10.0f * this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(0.0f, 0.0f, 0.0f), ArmourHUD.HUD_background_alpha);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[3].prefix, this.graphical_text_xpos, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[3].prefix_hue, gear_infos[3].prefix_saturation, gear_infos[3].prefix_luminosity), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[3].name, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[3].prefix) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(ArmourHUD.HUD_maximum_hue, 0.0f, 1.0f), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[3].value, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[3].prefix + gear_infos[3].name) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[3].fraction * ArmourHUD.HUD_maximum_hue, ArmourHUD.HUD_colour_saturation * 1.0f, 1.0f), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[3].postfix, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[3].prefix + gear_infos[3].name + gear_infos[3].value) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[3].postfix_hue, gear_infos[3].postfix_saturation, gear_infos[3].postfix_luminosity), ArmourHUD.HUD_text_alpha, false);
            }
        } else if (ArmourHUD.show_schematic) {
            this.hud_drawing_engine.drawHollowRect(this.left_leg_xcentre - this.shoe_width / 2.0f, this.shoe_ypos, this.shoe_width, this.shoe_height, 0.5f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
            this.hud_drawing_engine.drawHollowRect(this.right_leg_xcentre - this.shoe_width / 2.0f, this.shoe_ypos, this.shoe_width, this.shoe_height, 0.5f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
        }
        if (this.tool != null) {
            if (ArmourHUD.show_schematic) {
                this.hud_drawing_engine.drawShadedRect(this.armour_x_centre - this.torso_width / 2.0f - this.bodypart_spacing - this.arm_width, this.torso_ypos, this.arm_width, this.arm_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[4].fraction * ArmourHUD.HUD_maximum_hue, 1.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                this.hud_drawing_engine.drawShadedRect(this.armour_x_centre + this.torso_width / 2.0f + this.bodypart_spacing, this.torso_ypos, this.arm_width, this.arm_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[4].fraction * ArmourHUD.HUD_maximum_hue, 1.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                if (gear_infos[4].active) {
                    this.hud_drawing_engine.drawHollowRect(this.armour_x_centre - this.torso_width / 2.0f - this.bodypart_spacing - this.arm_width, this.torso_ypos, this.arm_width, this.arm_height, 2.0f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                    this.hud_drawing_engine.drawHollowRect(this.armour_x_centre + this.torso_width / 2.0f + this.bodypart_spacing, this.torso_ypos, this.arm_width, this.arm_height, 2.0f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
                }
            }
            if (ArmourHUD.HUD_position == 0) {
                this.graphical_text_xpos = this.box_border_spacing + this.armour_width + this.armour_width / 4.0f;
                this.graphical_text_ypos = this.y_offset + 30.0f * this.graphical_text_scaling;
            } else if (ArmourHUD.HUD_position == 1) {
                this.graphical_text_xpos = (float)disp_width - this.box_border_spacing - this.armour_width - this.armour_width / 4.0f - this.tool_string_width;
                this.graphical_text_ypos = this.y_offset + 30.0f * this.graphical_text_scaling;
            } else if (ArmourHUD.HUD_position == 2) {
                this.graphical_text_xpos = this.box_border_spacing + this.armour_width + this.armour_width / 4.0f;
                this.graphical_text_ypos = this.y_offset;
            } else {
                this.graphical_text_xpos = (float)disp_width - this.box_border_spacing - this.armour_width - this.armour_width / 4.0f - this.tool_string_width;
                this.graphical_text_ypos = this.y_offset;
            }
            if (ArmourHUD.show_text) {
                this.hud_drawing_engine.drawShadedRect(this.graphical_text_xpos - 1.0f * this.graphical_text_scaling, this.graphical_text_ypos - 1.0f * this.graphical_text_scaling, this.tool_string_width + 2.0f * this.graphical_text_scaling, 10.0f * this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(0.0f, 0.0f, 0.0f), ArmourHUD.HUD_background_alpha);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[4].prefix, this.graphical_text_xpos, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[4].prefix_hue, gear_infos[4].prefix_saturation, gear_infos[4].prefix_luminosity), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[4].name, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[4].prefix) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(ArmourHUD.HUD_maximum_hue, 0.0f, 1.0f), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[4].value, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[4].prefix + gear_infos[4].name) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[4].fraction * ArmourHUD.HUD_maximum_hue, ArmourHUD.HUD_colour_saturation * 1.0f, 1.0f), ArmourHUD.HUD_text_alpha, false);
                this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[4].postfix, this.graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[4].prefix + gear_infos[4].name + gear_infos[4].value) * this.graphical_text_scaling, this.graphical_text_ypos, this.graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[4].postfix_hue, gear_infos[4].postfix_saturation, gear_infos[4].postfix_luminosity), ArmourHUD.HUD_text_alpha, false);
            }
        } else if (ArmourHUD.show_schematic) {
            this.hud_drawing_engine.drawHollowRect(this.armour_x_centre - this.torso_width / 2.0f - this.bodypart_spacing - this.arm_width, this.torso_ypos, this.arm_width, this.arm_height, 0.5f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
            this.hud_drawing_engine.drawHollowRect(this.armour_x_centre + this.torso_width / 2.0f + this.bodypart_spacing, this.torso_ypos, this.arm_width, this.arm_height, 0.5f, this.hud_drawing_engine.HSVtoRGB(1.0f, 0.0f, 1.0f), ArmourHUD.HUD_armour_alpha);
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (this.minecraft.field_71441_e != null && event.phase == TickEvent.Phase.END) {
            this.onTickInGame();
        }
    }

    private void onTickInGame() {
        this.graphical_text_scaling = ArmourHUD.HUD_text_percentage;
        ScaledResolution scaledresolution = new ScaledResolution(this.minecraft);
        disp_width = scaledresolution.func_78326_a();
        disp_height = scaledresolution.func_78328_b();
        this.armour_height = (float)disp_height / 3.0f * ArmourHUD.HUD_size_percentage;
        this.armour_width = this.armour_height * 3.0f / 4.0f;
        this.x_offset = ArmourHUD.HUD_position == 0 || ArmourHUD.HUD_position == 2 ? this.box_border_spacing : (float)disp_width - this.box_border_spacing - this.armour_width;
        this.y_offset = ArmourHUD.HUD_position == 0 || ArmourHUD.HUD_position == 1 ? this.box_border_spacing : (float)disp_height - this.box_border_spacing - this.armour_height;
        this.torso_width = this.armour_width / 3.0f;
        this.torso_height = this.armour_height / 3.0f;
        this.head_width = this.torso_width / 3.0f;
        this.arm_width = this.torso_width / 4.0f;
        this.arm_height = this.torso_height * 3.0f / 4.0f;
        this.leg_width = this.torso_width / 3.0f;
        this.leg_height = this.armour_height / 4.0f;
        this.shoe_width = this.torso_width * 2.0f / 5.0f;
        this.shoe_height = this.leg_width;
        this.border_spacing = this.bodypart_spacing = this.armour_height / 20.0f;
        this.armour_x_centre = this.x_offset + this.armour_width / 2.0f;
        this.torso_ypos = this.border_spacing + this.head_width + this.bodypart_spacing + this.y_offset;
        this.left_leg_xcentre = this.armour_x_centre - this.torso_width / 2.0f + this.leg_width / 2.0f;
        this.right_leg_xcentre = this.armour_x_centre + this.torso_width / 2.0f - this.leg_width / 2.0f;
        this.shoe_ypos = this.torso_ypos + this.torso_height + this.leg_height + 2.0f * this.bodypart_spacing;
        this.hat = this.minecraft.field_71439_g.field_71071_by.func_70440_f(3);
        this.shirt = this.minecraft.field_71439_g.field_71071_by.func_70440_f(2);
        this.trousers = this.minecraft.field_71439_g.field_71071_by.func_70440_f(1);
        this.shoes = this.minecraft.field_71439_g.field_71071_by.func_70440_f(0);
        this.tool = this.minecraft.field_71439_g.field_71071_by.func_70448_g();
        if (!ArmourHUD.show_schematic) {
            this.armour_height = 0.0f;
            this.armour_width = 0.0f;
            if (ArmourHUD.HUD_position == 2 || ArmourHUD.HUD_position == 3) {
                this.y_offset = (float)disp_height - this.box_border_spacing - 40.0f * this.graphical_text_scaling;
            }
        }
        GearInfoContainer[] gear_info_array = new GearInfoContainer[]{this.gearInfo(this.hat), this.gearInfo(this.shirt), this.gearInfo(this.trousers), this.gearInfo(this.shoes), this.gearInfo(this.tool)};
        if (this.shirt != null && this.shirt.func_77973_b().getClass().getName() == "ic2.core.item.armor.ItemArmorJetpackElectric") {
            if (this.shirt.func_77942_o() && this.shirt.func_77978_p().func_74764_b("hoverMode") && this.shirt.func_77978_p().func_74767_n("hoverMode")) {
                gear_info_array[1].postfix = gear_info_array[1].postfix + " (Hover)";
                gear_info_array[1].postfix_hue = 240.0f;
                gear_info_array[1].postfix_saturation = 0.0f;
                gear_info_array[1].active = true;
            } else {
                gear_info_array[1].postfix = gear_info_array[1].postfix + " (Normal)";
                gear_info_array[1].postfix_hue = 240.0f;
                gear_info_array[1].postfix_saturation = 0.0f;
                gear_info_array[1].active = false;
            }
        }
        if (this.shirt != null && (this.shirt.func_77973_b().getClass().getName() == "gravisuite.ItemAdvancedJetpack" || this.shirt.func_77973_b().getClass().getName() == "gravisuite.ItemAdvancedNanoChestPlate")) {
            if (this.shirt.func_77942_o() && this.shirt.func_77978_p().func_74764_b("isHoverActive") && this.shirt.func_77978_p().func_74767_n("isHoverActive")) {
                gear_info_array[1].postfix = gear_info_array[1].postfix + " (Hover)";
                gear_info_array[1].postfix_hue = 240.0f;
                gear_info_array[1].postfix_saturation = 0.0f;
                gear_info_array[1].active = true;
            } else {
                gear_info_array[1].postfix = gear_info_array[1].postfix + " (Normal)";
                gear_info_array[1].postfix_hue = 240.0f;
                gear_info_array[1].postfix_saturation = 0.0f;
                gear_info_array[1].active = false;
            }
        }
        if (this.shirt != null && this.shirt.func_77973_b().getClass().getName() == "gravisuite.ItemGraviChestPlate") {
            if (this.shirt.func_77942_o() && this.shirt.func_77978_p().func_74764_b("isFlyActive") && this.shirt.func_77978_p().func_74767_n("isFlyActive")) {
                gear_info_array[1].postfix = gear_info_array[1].postfix + " (On)";
                gear_info_array[1].postfix_hue = 120.0f;
                gear_info_array[1].postfix_saturation = 1.0f;
                gear_info_array[1].active = true;
            } else {
                gear_info_array[1].postfix = gear_info_array[1].postfix + " (Off)";
                gear_info_array[1].postfix_hue = 1.0f;
                gear_info_array[1].postfix_saturation = 1.0f;
                gear_info_array[1].active = false;
            }
        }
        if (this.tool != null && this.tool.func_77973_b().getClass().getName() == "ic2.core.item.tool.ItemNanoSaber") {
            if (this.tool.func_77942_o() && this.tool.func_77978_p().func_74764_b("active") && this.tool.func_77978_p().func_74767_n("active")) {
                gear_info_array[4].postfix = gear_info_array[4].postfix + " (On)";
                gear_info_array[4].postfix_hue = 120.0f;
                gear_info_array[4].postfix_saturation = 1.0f;
                gear_info_array[4].active = true;
            } else {
                gear_info_array[4].postfix = gear_info_array[4].postfix + " (Off)";
                gear_info_array[4].postfix_hue = 1.0f;
                gear_info_array[4].postfix_saturation = 1.0f;
                gear_info_array[4].active = false;
            }
        }
        if (this.shirt != null && (this.shirt.func_77973_b().getClass().getName() == "tonius.simplyjetpacks.itemJetpack" || this.shirt.func_77973_b().getClass().getName() == "tonius.simplyjetpacks.item.FluxPack") && this.shirt.func_77942_o()) {
            if (this.shirt.func_77978_p().func_74764_b("JetpackHoverModeOn") && this.shirt.func_77978_p().func_74767_n("JetpackHoverModeOn")) {
                gear_info_array[1].postfix = gear_info_array[1].postfix + " (Hover)";
                gear_info_array[1].postfix_hue = 240.0f;
                gear_info_array[1].postfix_saturation = 0.0f;
            } else {
                gear_info_array[1].postfix = gear_info_array[1].postfix + " (Normal)";
                gear_info_array[1].postfix_hue = 240.0f;
                gear_info_array[1].postfix_saturation = 0.0f;
            }
            if (this.shirt.func_77978_p().func_74764_b("PackOn") && !this.shirt.func_77978_p().func_74767_n("PackOn")) {
                gear_info_array[1].prefix = gear_info_array[1].prefix + "(Disabled) ";
                gear_info_array[1].prefix_hue = 240.0f;
                gear_info_array[1].prefix_saturation = 0.0f;
                gear_info_array[1].active = false;
            } else {
                gear_info_array[1].active = true;
            }
        }
        if (this.hat != null && this.hat.func_77973_b() instanceof IArmourHUDProperties) {
            gear_info_array[0] = new GearInfoContainer((IArmourHUDProperties)this.hat.func_77973_b());
        }
        if (this.shirt != null && this.shirt.func_77973_b() instanceof IArmourHUDProperties) {
            gear_info_array[1] = new GearInfoContainer((IArmourHUDProperties)this.shirt.func_77973_b());
        }
        if (this.trousers != null && this.trousers.func_77973_b() instanceof IArmourHUDProperties) {
            gear_info_array[2] = new GearInfoContainer((IArmourHUDProperties)this.trousers.func_77973_b());
        }
        if (this.shoes != null && this.shoes.func_77973_b() instanceof IArmourHUDProperties) {
            gear_info_array[3] = new GearInfoContainer((IArmourHUDProperties)this.shoes.func_77973_b());
        }
        if (this.tool != null && this.tool.func_77973_b() instanceof IArmourHUDProperties) {
            gear_info_array[4] = new GearInfoContainer((IArmourHUDProperties)this.tool.func_77973_b());
        }
        this.hat_string_width = this.hud_drawing_engine.getStringWidth(gear_info_array[0].prefix + gear_info_array[0].name + gear_info_array[0].value + gear_info_array[0].postfix) * this.graphical_text_scaling;
        this.shirt_string_width = this.hud_drawing_engine.getStringWidth(gear_info_array[1].prefix + gear_info_array[1].name + gear_info_array[1].value + gear_info_array[1].postfix) * this.graphical_text_scaling;
        this.trousers_string_width = this.hud_drawing_engine.getStringWidth(gear_info_array[2].prefix + gear_info_array[2].name + gear_info_array[2].value + gear_info_array[2].postfix) * this.graphical_text_scaling;
        this.shoes_string_width = this.hud_drawing_engine.getStringWidth(gear_info_array[3].prefix + gear_info_array[3].name + gear_info_array[3].value + gear_info_array[3].postfix) * this.graphical_text_scaling;
        this.tool_string_width = this.hud_drawing_engine.getStringWidth(gear_info_array[4].prefix + gear_info_array[4].name + gear_info_array[4].value + gear_info_array[4].postfix) * this.graphical_text_scaling;
        if (ArmourHUD.HUD_position != 4 && !this.minecraft.field_71474_y.field_74330_P) {
            ArmourHUD_ticker armourHUD_ticker = this;
            if (armourHUD_ticker.minecraft.func_71382_s() && this.minecraft.field_71415_G) {
                this.graphicalStatus(this.minecraft, gear_info_array);
            }
        }
    }
}

