package fruitmods.armourhud;

import java.text.DecimalFormat;
import java.lang.Math;

import java.util.Arrays;

import net.minecraft.client.Minecraft;

import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.client.gui.ScaledResolution;

import net.minecraftforge.fml.client.FMLClientHandler;


import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
// yes, thank you for telling me that I need this included, tutorials...

import ic2.api.item.IElectricItem;
import cofh.redstoneflux.api.IEnergyContainerItem;
import net.minecraftforge.energy.IEnergyStorage;

// oh look, a separate package
import fruitmods.fruitlibs.mod_FruitLibs;
import fruitmods.fruitlibs.FruitDisplayLib;

// let the modders do the hard work here...
import fruitmods.api.armourhud.IArmourHUDProperties;


//TODO (in decreasing priority order):
// --another useful function here is for modders to say whether their helmets provide a HUD, then I don't need to check for special cases manually
// -make it so that items can display prefixes and postfixes only when you have a HUD helmet on (eg. target co-ordinates for a freqtrans)

public class ArmourHUD_ticker
{  
  
  // we need to somehow spin this off into a separate class and make an instance with new
  // that'll stop all these bullshit non-static context errors
  
  // alternative: make a constructor for ArmourHUD_ticker
  
  private Minecraft minecraft;
  private FruitDisplayLib hud_drawing_engine;
  
  
  private float hat_string_width = 0.0F;
  private float shirt_string_width = 0.0F;
  private float trousers_string_width = 0.0F;
  private float shoes_string_width = 0.0F;
  private float tool_string_width = 0.0F;
  
  
  DecimalFormat armour_percent;
  
  DecimalFormat coarse_armour_percent;
  
  // these variables are accessed from both multiple functions
  // and I don't like passing them as parameters
  ItemStack hat;
  ItemStack shirt;
  ItemStack trousers;
  ItemStack shoes;
  ItemStack tool;
  
  
  
  private static int disp_width;
  private static int disp_height;
  
  private float x_offset;
  private float y_offset;
  
  private float armour_x_centre;
  
  private float armour_width;
  private float armour_height;
  
  private float bodypart_spacing;
  // spacing between head and torso, torso and arms, torso and legs, legs and shoes
  
  private float border_spacing;
  // distance between top/bottom of armour figure and top/bottom of background
  
  private float head_width;
  // head will be automatically centred and is square
  // parameter here is vertical spacing between head and torso
  
  private float torso_width;
  private float torso_height;
  private float torso_ypos;
  // torso will be automatically centred
  
  private float arm_width;
  private float arm_height;
  // arms start level with the top of the torso
  // the only parameter is the spacing between the arm and the torso
  // arms will automatically be generated as a pair
  
  private float leg_width;
  private float leg_height;
  // likewise, legs start level with the torso's outer vertical edges
  // legs will be generated as a pair
  private float left_leg_xcentre;
  private float right_leg_xcentre;
  
  
  private float shoe_width;
  private float shoe_height;
  private float shoe_ypos;
  // we'll store the shoe ypos, since we'd have to evaluate it twice otherwise
  // saves minutely on execution time?
  // don't need xpos - shoes centre on the legs
  
  private float box_border_spacing = 2.0F;
  
  private float graphical_text_scaling;
  private float graphical_text_xpos;
  private float graphical_text_ypos;
  
  // private float space_char_width = 0.0F;
  // we don't actually use this thing, why is it even here?
  
  public ArmourHUD_ticker(FruitDisplayLib fruitdisplaylib)
  {
    this.minecraft = FMLClientHandler.instance().getClient();
    this.armour_percent = new DecimalFormat("###.#");
    this.coarse_armour_percent = new DecimalFormat("###");
    
    this.hud_drawing_engine = fruitdisplaylib;
    
  }
  
  
  private GearInfoContainer gearInfo(ItemStack gear)
  {
    // even if the item is null, this function insures that we get an initialised container
    // so we can stuff them all in an array and access them just fine
    // for reference, the array members will be: 0 = hat, 1 = shirt, 2 = trousers, 3 = shoes, 4 = tool
    GearInfoContainer gear_info = new GearInfoContainer();
    
    float currentValue = 0.0F;
    float maxValue = 0.0F;
    
    if(gear != null && gear.getItem() != Items.AIR)
    {
      // name bit
      gear_info.name = gear.getDisplayName() + "";
      
      if(gear_info.name == null || gear_info.name == "")
      {
	gear_info.name = "Unknown";
      }
      else
      {
	// get rid of those stupid section symbols, sanitise my display names >:(
	// section symbol = 167
	
	int i = 0;
	int j = gear_info.name.length();
	while(i < j)
	{
	  if(gear_info.name.charAt(i) == 167)
	  {
	    if(i + 1 < gear_info.name.length())
	    {
	      String temp1 = gear_info.name.substring(0, i);
	      String temp2 = gear_info.name.substring(i + 2, gear_info.name.length());
	      gear_info.name = temp1 + temp2;
	      j = gear_info.name.length();
	    }
	    else
	    {
	      String temp1 = gear_info.name.substring(0, i);
	      gear_info.name = temp1;
	      j = gear_info.name.length();
	    }
	  }
	  
	  i++;
	}
	
	if(ArmourHUD.item_abbreviations.containsKey(gear_info.name))
	{
	  gear_info.name = ArmourHUD.item_abbreviations.get(gear_info.name);
	}
	else
	{
	  ArmourHUD.item_abbreviations.put(gear_info.name, ArmourHUD.loadAbbreviatedItemName(gear_info.name));
	}
      }
      
      // value bit
      if(ArmourHUD.is_IC2_installed && gear.getItem() instanceof IElectricItem)
      {
	// IC2 Energy Units
	IElectricItem temp_gear = (IElectricItem)gear.getItem();
	
	maxValue = (float)temp_gear.getMaxCharge(gear);
	
	if(maxValue != 0.0F)
	{
	  if(gear.hasTagCompound() && gear.getTagCompound().hasKey("charge"))
	  {
	    currentValue = (float)gear.getTagCompound().getInteger("charge");
	  }
	  else
	  {
	    currentValue = 0.0F;
	  }
	  
	  
	  if(currentValue == 0.0F)
	  {
	    gear_info.fraction = 0.0F;
	  }
	  else
	  {
	    gear_info.fraction = currentValue / maxValue;
	  }
	  
	  gear_info.name = gear_info.name + ": ";
	  
	  if(ArmourHUD.always_percentages)
	  {
	    gear_info.value = armour_percent.format(gear_info.fraction * 100.0F) + "%";
	  }
	  else
	  {
	    gear_info.value = Float.toString(currentValue) + "/" + Float.toString(maxValue) + " EU";
	  }
	}
	
      }
      else if(ArmourHUD.is_TE_installed && gear.getItem() instanceof IEnergyContainerItem)
      {
	// Redstone Flux
	IEnergyContainerItem temp_gear = (IEnergyContainerItem)gear.getItem();
	currentValue = (float)temp_gear.getEnergyStored(gear);
	maxValue = (float)temp_gear.getMaxEnergyStored(gear);
	
	if(maxValue != 0.0F)
	{
	  if(currentValue == 0.0F)
	  {
	    gear_info.fraction = 0.0F;
	  }
	  else
	  {
	    gear_info.fraction = currentValue / maxValue;
	  }
	  
	  gear_info.name = gear_info.name + ": ";
	  
	  if(ArmourHUD.always_percentages)
	  {
	    gear_info.value = armour_percent.format(gear_info.fraction * 100.0F) + "%";
	  }
	  else
	  {
	    gear_info.value = Float.toString(currentValue) + "/" + Float.toString(maxValue) + " RF";
	  }
	}
	
      }
      else if(gear.getItem() instanceof IEnergyStorage)
      {
	// Forge Energy
	IEnergyStorage temp_gear = (IEnergyStorage)gear.getItem();
	currentValue = (float)temp_gear.getEnergyStored();
	maxValue = (float)temp_gear.getMaxEnergyStored();
	
	if(maxValue != 0.0F)
	{
	  if(currentValue == 0.0F)
	  {
	    gear_info.fraction = 0.0F;
	  }
	  else
	  {
	    gear_info.fraction = currentValue / maxValue;
	  }
	  
	  gear_info.name = gear_info.name + ": ";
	  
	  if(ArmourHUD.always_percentages)
	  {
	    gear_info.value = armour_percent.format(gear_info.fraction * 100.0F) + "%";
	  }
	  else
	  {
	    gear_info.value = Float.toString(currentValue) + "/" + Float.toString(maxValue) + " FE";
	  }
	}
      }
      
      
      // else if(gear.hasTagCompound() && gear.getTagCompound().hasKey("TotalDurability") && gear.getTagCompound().hasKey("Damage"))
      // else if(gear.hasTagCompound() && gear.getTagCompound().getCompoundTag("InfiTool").hasKey("TotalDurability") && gear.getTagCompound().getCompoundTag("InfiTool").hasKey("Damage"))
      
      // try as I might, I just can't get it to recognise Tinkers' tools
      // you're just going to have to live with having no information :(
      
      else if(gear.hasTagCompound() && gear.getTagCompound().hasKey("InfiTool"))
      {
	// Tinkers' Construct compatibility hax
	gear_info.name = gear_info.name + ": ";
	int damage = gear.getTagCompound().getCompoundTag("InfiTool").getInteger("Damage");
	int durability = gear.getTagCompound().getCompoundTag("InfiTool").getInteger("TotalDurability");
	gear_info.fraction = (float)(durability - damage) / (float)durability;
	
	if(ArmourHUD.always_percentages)
	{
	  gear_info.value = armour_percent.format(gear_info.fraction * 100.0F) + "%";
	}
	else
	{
	  gear_info.value = Integer.toString(durability - damage) + "/" + Integer.toString(durability);
	}
      }
      else if(gear.getItem().isDamageable())
      {
	gear_info.name = gear_info.name + ": ";
	gear_info.fraction = (float)(gear.getMaxDamage() - gear.getItemDamage()) / (float)gear.getMaxDamage();
	
	if(ArmourHUD.always_percentages)
	{
	  gear_info.value = armour_percent.format(gear_info.fraction * 100.0F) + "%";
	}
	else
	{
	  gear_info.value = Integer.toString(gear.getMaxDamage() - gear.getItemDamage()) + "/" + Integer.toString(gear.getMaxDamage());
	}
      }
      else if(gear.getItem().getItemStackLimit() > 1)
      {
	gear_info.prefix = Integer.toString(gear.getCount()) + "x ";
      }
      else
      {
	// this was in the old ArmourHUD and I can't remember why
	// it might be to ensure that you get white text
	gear_info.fraction = 2.0F;
      }
    }
    
    return gear_info;
  }
  
  
  public void graphicalStatus(Minecraft minecraft, GearInfoContainer[] gear_infos)
  {
    // this function handles drawing the graphical status panel and the text status
    // all of the information is taken from class global variables
    
    if(ArmourHUD.show_schematic)
    {
      // background for armour status panel
      this.hud_drawing_engine.drawShadedRect(x_offset, y_offset, armour_width, armour_height, this.hud_drawing_engine.HSVtoRGB(0.0F, 0.0F, 0.0F), ArmourHUD.HUD_background_alpha);
    }
    
    if(hat != null)
    {
      
      if(ArmourHUD.show_schematic)
      {
	// draw the head
	// head ypos = torso ypos - bodypart_spacing - head_width
	// head xpos = armour_x_centre - (head_width / 2.0F)
	this.hud_drawing_engine.drawShadedRect(armour_x_centre - (head_width / 2.0F), torso_ypos - bodypart_spacing - head_width, head_width, head_width, this.hud_drawing_engine.HSVtoRGB(gear_infos[0].fraction * ArmourHUD.HUD_maximum_hue, 1.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	
	if(gear_infos[0].active)
	{
	  this.hud_drawing_engine.drawHollowRect(armour_x_centre - (head_width / 2.0F), torso_ypos - bodypart_spacing - head_width, head_width, head_width, 2.0F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	}
	
      }
      
      if(ArmourHUD.HUD_position == 0)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	graphical_text_ypos = y_offset;
      }
      else if(ArmourHUD.HUD_position == 1)
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - hat_string_width;
	graphical_text_ypos = y_offset;
      }
      else if(ArmourHUD.HUD_position == 2)
      {
	graphical_text_xpos = box_border_spacing;
	graphical_text_ypos = y_offset - 30.0F * graphical_text_scaling;
      }
      else
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - hat_string_width;
	graphical_text_ypos = y_offset - 30.0F * graphical_text_scaling;
      }
      
      if(ArmourHUD.show_text)
      {
	// background for the text - makes it easier to see
	this.hud_drawing_engine.drawShadedRect(graphical_text_xpos - 1.0F * graphical_text_scaling, graphical_text_ypos - 1.0F * graphical_text_scaling, hat_string_width + 2.0F * graphical_text_scaling, 10.0F * graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(0.0F, 0.0F, 0.0F), ArmourHUD.HUD_background_alpha);
	
	// ATTACK OF THE MUTANT KILLER FUDGE FACTOR FROM SPACE!!1
	
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[0].prefix, graphical_text_xpos, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[0].prefix_hue, gear_infos[0].prefix_saturation, gear_infos[0].prefix_luminosity), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[0].name, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[0].prefix) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(ArmourHUD.HUD_maximum_hue, 0.0F, 1.0F), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[0].value, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[0].prefix + gear_infos[0].name) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[0].fraction * ArmourHUD.HUD_maximum_hue, ArmourHUD.HUD_colour_saturation * 1.0F, 1.0F), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[0].postfix, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[0].prefix + gear_infos[0].name + gear_infos[0].value) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[0].postfix_hue, gear_infos[0].postfix_saturation, gear_infos[0].postfix_luminosity), ArmourHUD.HUD_text_alpha, false);
	
	// hat string is level with the top of the armour box, not the head
	// since the head icon is so small
	// when the display is on the bottom, we'll put the hat status above the box
	// so that we don't obscure the original Minecraft HUD
	
	// draw: gear_infos[0].prefix + gear_infos[0].name + gear_infos[0].value + gear_infos[0].postfix
	// only value has a colour at the moment
	// each string is responsible for adding its own spacings
	// this is so that I can have 64x(item) - it looks nicer without a space
      }
      
    }
    else
    {
      if(ArmourHUD.show_schematic)
      {
	this.hud_drawing_engine.drawHollowRect(armour_x_centre - (head_width / 2.0F), torso_ypos - bodypart_spacing - head_width, head_width, head_width, 0.5F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
      }
    }
    
    if(shirt != null)
    {
      if(ArmourHUD.show_schematic)
      {
	// draw the torso
	this.hud_drawing_engine.drawShadedRect(armour_x_centre - (torso_width / 2.0F), torso_ypos, torso_width, torso_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[1].fraction * ArmourHUD.HUD_maximum_hue, 1.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	
	
	// draw a white outline on the torso to indicate whether it's active
	if(gear_infos[1].active)
	{
	  this.hud_drawing_engine.drawHollowRect(armour_x_centre - (torso_width / 2.0F), torso_ypos, torso_width, torso_height, 2.0F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	}
      }
      
      
      if(ArmourHUD.HUD_position == 0)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	// graphical_text_ypos = (float)torso_ypos - (float)bodypart_spacing;
	graphical_text_ypos = y_offset + 15.0F * graphical_text_scaling;
      }
      else if(ArmourHUD.HUD_position == 1)
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - shirt_string_width;
	// graphical_text_ypos = (float)torso_ypos - (float)bodypart_spacing;
	graphical_text_ypos = y_offset + 15.0F * graphical_text_scaling;
      }
      else if(ArmourHUD.HUD_position == 2)
      {
	graphical_text_xpos = box_border_spacing;
	graphical_text_ypos = y_offset - 15.0F * graphical_text_scaling;
      }
      else
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - shirt_string_width;
	graphical_text_ypos = y_offset - 15.0F * graphical_text_scaling;
      }
      
      
      if(ArmourHUD.show_text)
      {
	this.hud_drawing_engine.drawShadedRect(graphical_text_xpos - 1.0F * graphical_text_scaling, graphical_text_ypos - 1.0F * graphical_text_scaling, shirt_string_width + (2.0F * graphical_text_scaling), 10.0F * graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(0.0F, 0.0F, 0.0F), ArmourHUD.HUD_background_alpha);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[1].prefix, graphical_text_xpos, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[1].prefix_hue, gear_infos[1].prefix_saturation, gear_infos[1].prefix_luminosity), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[1].name, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[1].prefix) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(ArmourHUD.HUD_maximum_hue, 0.0F, 1.0F), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[1].value, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[1].prefix + gear_infos[1].name) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[1].fraction * ArmourHUD.HUD_maximum_hue, ArmourHUD.HUD_colour_saturation * 1.0F, 1.0F), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[1].postfix, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[1].prefix + gear_infos[1].name + gear_infos[1].value) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[1].postfix_hue, gear_infos[1].postfix_saturation, gear_infos[1].postfix_luminosity), ArmourHUD.HUD_text_alpha, false);
	
	
	// shirt string is level with the head
	// since the head icon is so small
	// when the display is on the bottom, we'll put the hat status above the box
	// so that we don't obscure the original Minecraft HUD
      }
      
    }
    else
    {
      if(ArmourHUD.show_schematic)
      {
	this.hud_drawing_engine.drawHollowRect(armour_x_centre - (torso_width / 2.0F), torso_ypos, torso_width, torso_height, 0.5F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
      }
    }
    
    if(trousers != null)
    {
      if(ArmourHUD.show_schematic)
      {
	// draw the legs
	// legs ypos = torso ypos + torso_height + bodypart_spacing
	// first leg xpos = torso xpos
	// second leg xpos = torso xpos + torso_width - leg_width
	// = armour_x_centre + (torso_width / 2.0F - leg_width
	
	// let's change things a little and have the leg centre positions stored in variables
	// since we'll be accessing them later for the shoe positions
	// leg 1:
	this.hud_drawing_engine.drawShadedRect(left_leg_xcentre - (leg_width / 2.0F), torso_ypos + torso_height + bodypart_spacing, leg_width, leg_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[2].fraction * ArmourHUD.HUD_maximum_hue, 1.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	// leg 2:
	this.hud_drawing_engine.drawShadedRect(right_leg_xcentre - (leg_width / 2.0F), torso_ypos + torso_height + bodypart_spacing, leg_width, leg_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[2].fraction * ArmourHUD.HUD_maximum_hue, 1.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	
	if(gear_infos[2].active)
	{
	  // leg 1:
	  this.hud_drawing_engine.drawHollowRect(left_leg_xcentre - (leg_width / 2.0F), torso_ypos + torso_height + bodypart_spacing, leg_width, leg_height, 2.0F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	  // leg 2:
	  this.hud_drawing_engine.drawHollowRect(right_leg_xcentre - (leg_width / 2.0F), torso_ypos + torso_height + bodypart_spacing, leg_width, leg_height, 2.0F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	}
	
      }
      
      
      if(ArmourHUD.HUD_position == 0)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	graphical_text_ypos = y_offset + 45.0F * graphical_text_scaling;
	// 10.0F is the normal spacing between lines, so we scale it here
	// makes my life easier...
      }
      else if(ArmourHUD.HUD_position == 1)
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - trousers_string_width;
	graphical_text_ypos = y_offset + 45.0F * graphical_text_scaling;
      }
      else if(ArmourHUD.HUD_position == 2)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	// graphical_text_ypos = (float)torso_ypos - (float)bodypart_spacing;
	graphical_text_ypos = y_offset + 15.0F * graphical_text_scaling;
	// using 15.0F here, so that we get more spacing
	// not vital, but it'll look just that little bit nicer
      }
      else
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - trousers_string_width;
	graphical_text_ypos = y_offset + 15.0F * graphical_text_scaling;
      }
      
      
      if(ArmourHUD.show_text)
      {
	this.hud_drawing_engine.drawShadedRect(graphical_text_xpos - 1.0F * graphical_text_scaling, graphical_text_ypos - 1.0F * graphical_text_scaling, trousers_string_width + 2.0F * graphical_text_scaling, 10.0F * graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(0.0F, 0.0F, 0.0F), ArmourHUD.HUD_background_alpha);
	
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[2].prefix, graphical_text_xpos, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[2].prefix_hue, gear_infos[2].prefix_saturation, gear_infos[2].prefix_luminosity), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[2].name, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[2].prefix) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(ArmourHUD.HUD_maximum_hue, 0.0F, 1.0F), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[2].value, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[2].prefix + gear_infos[2].name) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[2].fraction * ArmourHUD.HUD_maximum_hue, ArmourHUD.HUD_colour_saturation * 1.0F, 1.0F), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[2].postfix, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[2].prefix + gear_infos[2].name + gear_infos[2].value) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[2].postfix_hue, gear_infos[2].postfix_saturation, gear_infos[2].postfix_luminosity), ArmourHUD.HUD_text_alpha, false);
	// trousers string sits level with the hips
      }
      
    }
    else
    {
      if(ArmourHUD.show_schematic)
      {
	// leg 1:
	this.hud_drawing_engine.drawHollowRect(left_leg_xcentre - (leg_width / 2.0F), torso_ypos + torso_height + bodypart_spacing, leg_width, leg_height, 0.5F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	// leg 2:
	this.hud_drawing_engine.drawHollowRect(right_leg_xcentre - (leg_width / 2.0F), torso_ypos + torso_height + bodypart_spacing, leg_width, leg_height, 0.5F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
      }
      
    }
    
    
    if(shoes != null)
    {
      if(ArmourHUD.show_schematic)
      {
	// draw the shoes
	// shoes ypos = torso ypos + torso_height + leg_height + 2 * bodypart_spacing.
	
	// shoe 1:
	this.hud_drawing_engine.drawShadedRect(left_leg_xcentre - (shoe_width / 2.0F), shoe_ypos, shoe_width, shoe_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[3].fraction * ArmourHUD.HUD_maximum_hue, 1.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	// shoe 2:
	this.hud_drawing_engine.drawShadedRect(right_leg_xcentre - (shoe_width / 2.0F), shoe_ypos, shoe_width, shoe_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[3].fraction * ArmourHUD.HUD_maximum_hue, 1.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	
	
	if(gear_infos[3].active)
	{
	  // shoe 1:
	  this.hud_drawing_engine.drawHollowRect(left_leg_xcentre - (shoe_width / 2.0F), shoe_ypos, shoe_width, shoe_height, 2.0F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	  // shoe 2:
	  this.hud_drawing_engine.drawHollowRect(right_leg_xcentre - (shoe_width / 2.0F), shoe_ypos, shoe_width, shoe_height, 2.0F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	}
      }
      
      
      if(ArmourHUD.HUD_position == 0)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	graphical_text_ypos = y_offset + 60.0F * graphical_text_scaling;
      }
      else if(ArmourHUD.HUD_position == 1)
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - shoes_string_width;
	graphical_text_ypos = y_offset + 60.0F * graphical_text_scaling;
      }
      else if(ArmourHUD.HUD_position == 2)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	// graphical_text_ypos = (float)torso_ypos - (float)bodypart_spacing;
	graphical_text_ypos = y_offset + 30.0F * graphical_text_scaling;
	// using 15.0F here, so that we get more spacing
	// not vital, but it'll look just that little bit nicer
      }
      else
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - shoes_string_width;
	graphical_text_ypos = y_offset + 30.0F * graphical_text_scaling;
      }
      
      
      if(ArmourHUD.show_text)
      {
	this.hud_drawing_engine.drawShadedRect(graphical_text_xpos - 1.0F * graphical_text_scaling, graphical_text_ypos - 1.0F * graphical_text_scaling, shoes_string_width + 2.0F * graphical_text_scaling, 10.0F * graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(0.0F, 0.0F, 0.0F), ArmourHUD.HUD_background_alpha);
	
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[3].prefix, graphical_text_xpos, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[3].prefix_hue, gear_infos[3].prefix_saturation, gear_infos[3].prefix_luminosity), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[3].name, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[3].prefix) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(ArmourHUD.HUD_maximum_hue, 0.0F, 1.0F), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[3].value, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[3].prefix + gear_infos[3].name) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[3].fraction * ArmourHUD.HUD_maximum_hue, ArmourHUD.HUD_colour_saturation * 1.0F, 1.0F), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[3].postfix, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[3].prefix + gear_infos[3].name + gear_infos[3].value) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[3].postfix_hue, gear_infos[3].postfix_saturation, gear_infos[3].postfix_luminosity), ArmourHUD.HUD_text_alpha, false);
      }
      
    }
    else
    {
      if(ArmourHUD.show_schematic)
      {
	// shoe 1:
	this.hud_drawing_engine.drawHollowRect(left_leg_xcentre - (shoe_width / 2.0F), shoe_ypos, shoe_width, shoe_height, 0.5F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	// shoe 2:
	this.hud_drawing_engine.drawHollowRect(right_leg_xcentre - (shoe_width / 2.0F), shoe_ypos, shoe_width, shoe_height, 0.5F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
      }
    }
    
    if(tool != null)
    {
      if(ArmourHUD.show_schematic)
      {
	// draw the arms
	// arm ypos = torso_ypos
	// left arm xpos = armour_x_centre - (torso_width / 2.0F) - bodypart_spacing - arm_width;
	// right arm xpos = armour_x_centre + (torso_width / 2.0F) + bodypart_spacing;
	// arm 1:
	this.hud_drawing_engine.drawShadedRect(armour_x_centre - (torso_width / 2.0F) - bodypart_spacing - arm_width, torso_ypos, arm_width, arm_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[4].fraction * ArmourHUD.HUD_maximum_hue, 1.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	// arm 2:
	this.hud_drawing_engine.drawShadedRect(armour_x_centre + (torso_width / 2.0F) + bodypart_spacing, torso_ypos, arm_width, arm_height, this.hud_drawing_engine.HSVtoRGB(gear_infos[4].fraction * ArmourHUD.HUD_maximum_hue, 1.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	
	
	if(gear_infos[4].active)
	{
	  this.hud_drawing_engine.drawHollowRect(armour_x_centre - (torso_width / 2.0F) - bodypart_spacing - arm_width, torso_ypos, arm_width, arm_height, 2.0F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	  // arm 2:
	  this.hud_drawing_engine.drawHollowRect(armour_x_centre + (torso_width / 2.0F) + bodypart_spacing, torso_ypos, arm_width, arm_height, 2.0F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	}
      }
      
      
      if(ArmourHUD.HUD_position == 0)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	graphical_text_ypos = y_offset + 30.0F * graphical_text_scaling;
	// 10.0F is the normal spacing between lines, so we scale it here
	// makes my life easier...
      }
      else if(ArmourHUD.HUD_position == 1)
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - tool_string_width;
	graphical_text_ypos = y_offset + 30.0F * graphical_text_scaling;
      }
      else if(ArmourHUD.HUD_position == 2)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	// graphical_text_ypos = (float)torso_ypos - (float)bodypart_spacing;
	graphical_text_ypos = y_offset;
	// using 15.0F here, so that we get more spacing
	// not vital, but it'll look just that little bit nicer
      }
      else
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - tool_string_width;
	graphical_text_ypos = y_offset;
      }
      
      
      if(ArmourHUD.show_text)
      {
	this.hud_drawing_engine.drawShadedRect(graphical_text_xpos - 1.0F * graphical_text_scaling, graphical_text_ypos - 1.0F * graphical_text_scaling, tool_string_width + 2.0F * graphical_text_scaling, 10.0F * graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(0.0F, 0.0F, 0.0F), ArmourHUD.HUD_background_alpha);
	
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[4].prefix, graphical_text_xpos, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[4].prefix_hue, gear_infos[4].prefix_saturation, gear_infos[4].prefix_luminosity), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[4].name, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[4].prefix) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(ArmourHUD.HUD_maximum_hue, 0.0F, 1.0F), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[4].value, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[4].prefix + gear_infos[4].name) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[4].fraction * ArmourHUD.HUD_maximum_hue, ArmourHUD.HUD_colour_saturation * 1.0F, 1.0F), ArmourHUD.HUD_text_alpha, false);
	
	this.hud_drawing_engine.renderScaledStringAtPos(gear_infos[4].postfix, graphical_text_xpos + this.hud_drawing_engine.getStringWidth(gear_infos[4].prefix + gear_infos[4].name + gear_infos[4].value) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, this.hud_drawing_engine.HSVtoRGB(gear_infos[4].postfix_hue, gear_infos[4].postfix_saturation, gear_infos[4].postfix_luminosity), ArmourHUD.HUD_text_alpha, false);
	// tool string is level with the middle of the torso when in the top positions
	// and sits level with the bottom of the head when in the bottom positions
      }
      
    }
    else
    {
      if(ArmourHUD.show_schematic)
      {
	this.hud_drawing_engine.drawHollowRect(armour_x_centre - (torso_width / 2.0F) - bodypart_spacing - arm_width, torso_ypos, arm_width, arm_height, 0.5F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
	// arm 2:
	this.hud_drawing_engine.drawHollowRect(armour_x_centre + (torso_width / 2.0F) + bodypart_spacing, torso_ypos, arm_width, arm_height, 0.5F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
      }
    }
    
  }
  
  
  @SubscribeEvent
  public void onRenderTick(TickEvent.RenderTickEvent event)
  {
    if(this.minecraft.world != null)
    {
      if(event.phase == TickEvent.Phase.END)
      {
	onTickInGame();
      }
    }
  }
  
  
  private void onTickInGame()
  {
    // yeah, we're running all this code every single time the game ticks
    // die, computer, die...
    
    graphical_text_scaling = ArmourHUD.HUD_text_percentage;
    
    ScaledResolution scaledresolution = new ScaledResolution(this.minecraft);
    // 1.7.10 constructor: 
    // ScaledResolution scaledresolution = new ScaledResolution(this.minecraft, this.minecraft.displayWidth, this.minecraft.displayHeight);
    // ScaledResolution scaledresolution = new ScaledResolution(this.minecraft.gameSettings, this.minecraft.displayWidth, this.minecraft.displayHeight);
    disp_width = scaledresolution.getScaledWidth();
    disp_height = scaledresolution.getScaledHeight();
    
    // ok, now we're going to make it configurable
    // we have this integer called ArmourHUD.HUD_position
    // if 0, it's in the top-left, if 1, it's in the top-right
    // if 2, it's in the bottom-left, if 3, it's in the bottom-right
    
    
    // status element size:
    // we'll have it 1/4 of the screen height and 1/8 of the width
    // too small, let's change it to 1/3 and 1/7
    
    // on second thoughts, we need a defined aspect ratio for the background
    // we'll fix the height with respect to the display height
    // and scale the width to that
    // how about we go for an aspect ratio of width = 0.75(height)?
    
    
    // we now need a way of scaling the graphical HUD
    // fortunately, I had the foresight to not only use variables instead of hardcoding it
    // but to chain the sizes off each other
    // so I can scale the armour height and everything else changes with it
    
    
    // armour_width = disp_width / 7;
    armour_height = (float)disp_height / 3.0F * ArmourHUD.HUD_size_percentage;
    // set size to zero if we're not showing the schematic
    // then I don't have to mess around with the drawing code so much
    armour_width = (armour_height * 3.0F) / 4.0F;
    // armour_width = (double)disp_height / 4.0F;
    // mathematically equivalent to above, but with less rounding error
    // rounding error re-introduced to make the scaling even easier
    
    
    x_offset = (ArmourHUD.HUD_position == 0 || ArmourHUD.HUD_position == 2) ? box_border_spacing : (float)disp_width - box_border_spacing - armour_width;
    
    y_offset = (ArmourHUD.HUD_position == 0 || ArmourHUD.HUD_position == 1) ? box_border_spacing : (float)disp_height - box_border_spacing - armour_height;
    
    
    // torso width = interior width / 3
    // torso height = interior height / 3
    torso_width = armour_width / 3.0F;
    torso_height = armour_height / 3.0F;
    
    // head height = head width = interior width / 5
    head_width = torso_width / 3.0F;
    // head will be automatically centred and is square
    
    arm_width = torso_width / 4.0F;
    arm_height = (torso_height * 3.0F) / 4.0F;
    // arms start level with the top of the torso
    
    leg_width = torso_width / 3.0F;
    leg_height = armour_height / 4.0F;
    
    // likewise, legs start level with the torso's outer vertical edges
    // parameter here is the vertical spacing between the legs and the torso
    // legs will be generated as a pair
    
    shoe_width = (torso_width * 2.0F) / 5.0F;
    shoe_height = leg_width;
    
    // currently, torso + head + leg + shoe heights = 75%
    // spacings: above, below, head-body, body-legs, legs-shoes
    // that's handy, we can make them all equal to 5% of the panel height
    
    bodypart_spacing = armour_height / 20.0F;
    border_spacing = bodypart_spacing;
    
    armour_x_centre = x_offset + (armour_width / 2.0F);
    torso_ypos = border_spacing + head_width + bodypart_spacing + y_offset;
    // above torso, we have: one head, one bodypart spacing and one border spacing
    // these two variables above tell us where we draw each body part
    // and change the centering
    // so don't forget to put in the offsets here
    
    left_leg_xcentre = armour_x_centre - (torso_width / 2.0F) + (leg_width / 2.0F);
    right_leg_xcentre = armour_x_centre + (torso_width / 2.0F) - (leg_width / 2.0F);
    shoe_ypos = torso_ypos + torso_height + leg_height + (2.0F * bodypart_spacing);
    
    
    // colours: use HSV with S and V at 100%
    // electric items can start at a nice deep blue, so that's H = 240/360
    // could start non-electric items at green, which is H = 120/360
    // but that might get a little confusing
    // depleted = red, which is H = 0/360
    // but we'll list actually depleted items as black (if they're electric)
    // no armour = hollow black
    // indestructible armour = white
    // green is actually half-way down, if we're using blue as max, so it might get a little misleading
    // ...meh, who cares - let's start at blue and work downwards from there
    
    // invalid values will come out of the function as (1,1,1), or white
    // perfect for the solar helmet, which gives an invalid value when tested for durability
    // so that we can take advantage of the "undefined" or NULL output from utility armours
    // RGB values outputted thus will range from 0 to 1 - perfect for my needs
    
    // also, you can supply a hue of -1.0F to get white
    
    
    
    hat = this.minecraft.player.inventory.armorItemInSlot(3);
    shirt = this.minecraft.player.inventory.armorItemInSlot(2);
    trousers = this.minecraft.player.inventory.armorItemInSlot(1);
    shoes = this.minecraft.player.inventory.armorItemInSlot(0);
    
    
    tool = this.minecraft.player.inventory.getCurrentItem();
    
    
    
    // bit of a nasty hack, but it means that I don't need to rewrite the text positioning code
    
    if(!ArmourHUD.show_schematic)
    {
      armour_height = 0.0F;
      armour_width = 0.0F;
      
      // this is a horrible hack to make the lower status text line up with the bottom of the screen
      // when the graphical HUD is disabled - otherwise, it hovers above it
      // it would be in the correct position if we had the graphical section
      // (high enough to avoid the quickbar and health displays)
      // but hovering above the bottom left without the graphical display
      if(ArmourHUD.HUD_position == 2 || ArmourHUD.HUD_position == 3)
      {
	y_offset = (float)disp_height - box_border_spacing - 40.0F * graphical_text_scaling;
	// number here: 30.0F = space from offset for text drawing + 10.0F for actual text height
      }
    }
    
    
    GearInfoContainer[] gear_info_array;
    
    gear_info_array = new GearInfoContainer[5];
    
    gear_info_array[0] = gearInfo(hat);
    gear_info_array[1] = gearInfo(shirt);
    gear_info_array[2] = gearInfo(trousers);
    gear_info_array[3] = gearInfo(shoes);
    gear_info_array[4] = gearInfo(tool);
    
    // my mod-specific integration goes here
    
    
    // IC2 Jetpack postfix code
    if(shirt != null && shirt.getItem().getClass().getName() == "ic2.core.item.armor.ItemArmorJetpackElectric")
    {
      if(shirt.hasTagCompound() && shirt.getTagCompound().hasKey("hoverMode") && shirt.getTagCompound().getBoolean("hoverMode"))
      {
	gear_info_array[1].postfix = gear_info_array[1].postfix + " (Hover)";
	gear_info_array[1].postfix_hue = 240.0F;
	gear_info_array[1].postfix_saturation = 0.0F;
	gear_info_array[1].active = true;
      }
      else
      {
	gear_info_array[1].postfix = gear_info_array[1].postfix + " (Normal)";
	gear_info_array[1].postfix_hue = 240.0F;
	gear_info_array[1].postfix_saturation = 0.0F;
	gear_info_array[1].active = false;
      }
    }
    
    // GraviSuite Jetpack postfix code
    if(shirt != null && (shirt.getItem().getClass().getName() == "gravisuite.ItemAdvancedJetpack" || shirt.getItem().getClass().getName() == "gravisuite.ItemAdvancedNanoChestPlate"))
    {
      if(shirt.hasTagCompound() && shirt.getTagCompound().hasKey("isHoverActive") && shirt.getTagCompound().getBoolean("isHoverActive"))
      {
	gear_info_array[1].postfix = gear_info_array[1].postfix + " (Hover)";
	gear_info_array[1].postfix_hue = 240.0F;
	gear_info_array[1].postfix_saturation = 0.0F;
	gear_info_array[1].active = true;
      }
      else
      {
	gear_info_array[1].postfix = gear_info_array[1].postfix + " (Normal)";
	gear_info_array[1].postfix_hue = 240.0F;
	gear_info_array[1].postfix_saturation = 0.0F;
	gear_info_array[1].active = false;
      }
    }
    
    // GraviChestPlate postfix code
    if(shirt != null && shirt.getItem().getClass().getName() == "gravisuite.ItemGraviChestPlate")
    {
      if(shirt.hasTagCompound() && shirt.getTagCompound().hasKey("isFlyActive") && shirt.getTagCompound().getBoolean("isFlyActive"))
      {
	gear_info_array[1].postfix = gear_info_array[1].postfix + " (On)";
	gear_info_array[1].postfix_hue = 120.0F;
	gear_info_array[1].postfix_saturation = 1.0F;
	gear_info_array[1].active = true;
      }
      else
      {
	gear_info_array[1].postfix = gear_info_array[1].postfix + " (Off)";
	gear_info_array[1].postfix_hue = 1.0F;
	gear_info_array[1].postfix_saturation = 1.0F;
	gear_info_array[1].active = false;
      }
    }
    
    // IC2 Nanosabre postfix code
    if(tool != null && tool.getItem().getClass().getName() == "ic2.core.item.tool.ItemNanoSaber")
    {
      if(tool.hasTagCompound() && tool.getTagCompound().hasKey("active") && tool.getTagCompound().getBoolean("active"))
	{
	  gear_info_array[4].postfix = gear_info_array[4].postfix + " (On)";
	  gear_info_array[4].postfix_hue = 120.0F;
	  gear_info_array[4].postfix_saturation = 1.0F;
	  gear_info_array[4].active = true;
	}
	else
	{
	  gear_info_array[4].postfix = gear_info_array[4].postfix + " (Off)";
	  gear_info_array[4].postfix_hue = 1.0F;
	  gear_info_array[4].postfix_saturation = 1.0F;
	  gear_info_array[4].active = false;
	}
    }
    
    // Simply Jetpacks (TE addon) prefix/postfix code
    // old classname: tonius.simplyjetpacks.item.jetpack.ItemJetpack
    // new one: tonius.simplyjetpacks.item.meta.Jetpack
    if(shirt != null && (shirt.getItem().getClass().getName() == "tonius.simplyjetpacks.itemJetpack" || shirt.getItem().getClass().getName() == "tonius.simplyjetpacks.item.FluxPack"))
    {
      
      if(shirt.hasTagCompound())
      {
	if(shirt.getTagCompound().hasKey("JetpackHoverModeOn") && shirt.getTagCompound().getBoolean("JetpackHoverModeOn"))
	{
	  gear_info_array[1].postfix = gear_info_array[1].postfix + " (Hover)";
	  gear_info_array[1].postfix_hue = 240.0F;
	  gear_info_array[1].postfix_saturation = 0.0F;
	}
	else
	{
	  gear_info_array[1].postfix = gear_info_array[1].postfix + " (Normal)";
	  gear_info_array[1].postfix_hue = 240.0F;
	  gear_info_array[1].postfix_saturation = 0.0F;
	}
	
	if(shirt.getTagCompound().hasKey("PackOn") && shirt.getTagCompound().getBoolean("PackOn") == false)
	{
	  gear_info_array[1].prefix = gear_info_array[1].prefix + "(Disabled) ";
	  gear_info_array[1].prefix_hue = 240.0F;
	  gear_info_array[1].prefix_saturation = 0.0F;
	  gear_info_array[1].active = false;
	}
	else
	{
	  gear_info_array[1].active = true;
	}
      }
      
    }
    
    // final step: if mod authors have made overrides for their items' display lines
    // we load them in now
    
    if(hat != null && hat.getItem() instanceof IArmourHUDProperties)
    {
      gear_info_array[0] = new GearInfoContainer((IArmourHUDProperties)hat.getItem());
    }
    if(shirt != null && shirt.getItem() instanceof IArmourHUDProperties)
    {
      gear_info_array[1] = new GearInfoContainer((IArmourHUDProperties)shirt.getItem());
    }
    if(trousers != null && trousers.getItem() instanceof IArmourHUDProperties)
    {
      gear_info_array[2] = new GearInfoContainer((IArmourHUDProperties)trousers.getItem());
    }
    if(shoes != null && shoes.getItem() instanceof IArmourHUDProperties)
    {
      gear_info_array[3] = new GearInfoContainer((IArmourHUDProperties)shoes.getItem());
    }
    if(tool != null && tool.getItem() instanceof IArmourHUDProperties)
    {
      gear_info_array[4] = new GearInfoContainer((IArmourHUDProperties)tool.getItem());
    }
    
    
    // note that we still need to calculate the string width manually
    // this was not added to GearInfoContainer because it would add more dependencies :(
    
    hat_string_width = this.hud_drawing_engine.getStringWidth(gear_info_array[0].prefix + gear_info_array[0].name + gear_info_array[0].value + gear_info_array[0].postfix) * graphical_text_scaling;
    shirt_string_width = this.hud_drawing_engine.getStringWidth(gear_info_array[1].prefix + gear_info_array[1].name + gear_info_array[1].value + gear_info_array[1].postfix) * graphical_text_scaling;
    trousers_string_width = this.hud_drawing_engine.getStringWidth(gear_info_array[2].prefix + gear_info_array[2].name + gear_info_array[2].value + gear_info_array[2].postfix) * graphical_text_scaling;
    shoes_string_width = this.hud_drawing_engine.getStringWidth(gear_info_array[3].prefix + gear_info_array[3].name + gear_info_array[3].value + gear_info_array[3].postfix) * graphical_text_scaling;
    tool_string_width = this.hud_drawing_engine.getStringWidth(gear_info_array[4].prefix + gear_info_array[4].name + gear_info_array[4].value + gear_info_array[4].postfix) * graphical_text_scaling;
    
    /*
    if(tool != null)
    {
      System.out.println("(Tool) Pre: " + tool_prefix + " Name: " + tool_name + " Val: " + tool_value + " Post: " + tool_postfix);
    }
    */
    
    
    if(ArmourHUD.HUD_position != 4 && !minecraft.gameSettings.showDebugInfo && minecraft.isGuiEnabled() && minecraft.inGameHasFocus)
    {
      graphicalStatus(minecraft, gear_info_array);
    }
    
    // see World.java. line 3706 (public List getEntitiesWithinAABB), can pass the relevant class to it
    // will be very useful for Upcoming Features (tm)
    // also see http://forums.bukkit.org/threads/monsters-in-an-area.7386/ for this function:
    
    // loc = thePlayer.getLocation();
    // but you might need to adjust for Bukkit code...
    
    // double x = loc.getX()+0.5;
    // double y = loc.getY()+0.5;
    // double z = loc.getZ()+0.5;
    // double radius = 10;
    
    // AxisAlignedBB bb = AxisAlignedBB.a(x-radius,y-radius,z-radius,x+radius,y+radius,z+radius);
    
    
    // test strings, uncomment to check the font rendering engine
    
    // this.hud_drawing_engine.renderScaledStringAtPos("QuantumSuit Helmet 9.85%", 200.0F, 100.0F, 0.6F, this.hud_drawing_engine.HSVtoRGB(1.0F, 1.0F, 1.0F), ArmourHUD.HUD_armour_alpha);
    
    // this.hud_drawing_engine.renderScaledStringAtPos("OMGTEST2", 200.0F, 160.0F, 0.6F, this.hud_drawing_engine.HSVtoRGB(1.0F, 0.0F, 1.0F), 1.0F, false);
    
  }
  
}
