package fruitmods.armourhud;

import java.io.File;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.logging.Logger;

import net.minecraft.client.settings.KeyBinding;


import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
// use: Loader.getConfigDir()
// I feel very uneasy doing things this way, Loader seems like a pretty low-level class
// import net.minecraftforge.fml.common.Loader;

import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Mod.EventHandler;
import net.minecraftforge.fml.common.Mod.Instance;

import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
// import net.minecraftforge.fml.common.registry.LanguageRegistry;

import net.minecraftforge.fml.relauncher.Side;

import net.minecraftforge.fml.common.FMLCommonHandler;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;


import fruitmods.fruitlibs.mod_FruitLibs;

// it *must* load after FruitLibs, otherwise you get a NPE when attempting to call this.hud_drawing_engine.getStringWidth
@Mod(modid = ArmourHUD.MODID, name = ArmourHUD.MOD_NAME, version = ArmourHUD.VERSION, dependencies="required-after:fruitmods_fruitlibs@[1.6,)", acceptableRemoteVersions = "*")
@SideOnly(Side.CLIENT)
public class ArmourHUD
{
  public static final String MODID = "armourhud";
  public static final String MOD_NAME = "Armour HUD";
  public static final String VERSION = "3.2";
  
  @Mod.Instance("ArmourHUD")
  public static ArmourHUD instance;
  
  public static Logger log = Logger.getLogger("Armour HUD");
  
  public static boolean is_IC2_installed = true;
  public static boolean is_TE_installed = true;
  // public static boolean is_UE_installed = true;
  // the UE website appears to have been domain parked, treat the mod as defunct
  
  // Forge Energy is the third category, but that's present by default from MC r1.10 onwards
  
  public static int HUD_position;
  public static boolean show_schematic;
  public static boolean show_text;
  public static boolean always_percentages;
  public static float HUD_size_percentage;
  public static float HUD_text_percentage;
  public static float HUD_colour_saturation;
  public static float HUD_maximum_hue;
  public static float HUD_background_alpha;
  public static float HUD_armour_alpha;
  public static float HUD_text_alpha;
    
  static Configuration armour_HUD_config;
  
  public static TreeMap<String, String> item_abbreviations = new TreeMap<String, String>();
  
  // private float space_char_width = 0.0F;
  
  @EventHandler
  public void preInit(FMLPreInitializationEvent event)
  {
    armour_HUD_config = new Configuration(event.getSuggestedConfigurationFile());
    
    armour_HUD_config.load();
    HUD_position = Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Position", 2).getString());
    
    // ok, I can't figure out how to put comments in the config file
    // and the Minecraft Forge website/forum is completely useless
    // so we'll have to trust in the readme...
    
    // HUD position code: 0 = top-left, 1 = top-right, 2 = bottom-left, 3 = bottom-right, 4 = off
    // while I personally prefer it in the bottom left
    // Thaumcraft's Goggles also sit there and I don't know if you can move them
    // due to changes in TC, I'm fine with putting it in the bottom-left now.
    
    if(HUD_position < 0 || HUD_position > 4)
      HUD_position = 2;
    // no, bad user...
      
      
      show_schematic = Boolean.parseBoolean(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "Show HUD Schematic", false).getString());
      
      show_text = Boolean.parseBoolean(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "Show HUD Text", true).getString());
      
      always_percentages = Boolean.parseBoolean(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "Use Percentages instead of exact values", false).getString());
      
      
      // legal values: 1-150
      // default: 75 - was 50, but unicode text seems to be smaller
      // putting it back to 50 - it's too large when maximised on a 1920x1080 screen
      // setting it to 75 doesn't make it any more readable when non-magnified, which was the point of changing it
      // let's try 60 instead
      HUD_text_percentage = (float)Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Text Size Percentage", 60).getString()) / 100.0F;
      
      if(HUD_text_percentage < 0.01F || HUD_text_percentage > 1.5F)
	HUD_text_percentage = 0.75F;
      
      
      // legal values: 1-150
      // default: 60
	HUD_size_percentage = (float)Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Graphics Size Percentage", 60).getString()) / 100.0F;
      
      if(HUD_size_percentage < 0.01F || HUD_size_percentage > 1.5F)
	HUD_size_percentage = 1.0F;
      
      // legal values: 1-100
      // default: 70
	HUD_colour_saturation = (float)Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Colour Saturation", 70).getString()) / 100.0F;
      
      if(HUD_colour_saturation < 0.0F || HUD_colour_saturation > 1.0F)
	HUD_colour_saturation = 1.0F;
      
      // legal values: 1-360
      // default: 240
	HUD_maximum_hue = (float)Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Maximum Hue", 240).getString());
	
      if(HUD_maximum_hue < 1.0F || HUD_maximum_hue > 360.0F)
	HUD_maximum_hue = 240.0F;
      
      // legal values: 1-100
      // default: 50
      HUD_background_alpha = (float)Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Background Opacity", 50).getString()) / 100.0F;
      
      if(HUD_background_alpha < 0.0F || HUD_background_alpha > 1.0F)
	HUD_background_alpha = 0.5F;
	
      // legal values: 1-100
      // default: 60
      HUD_armour_alpha = (float)Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Graphics Opacity", 60).getString()) / 100.0F;
      
      if(HUD_armour_alpha < 0.0F || HUD_armour_alpha > 1.0F)
	HUD_armour_alpha = 0.6F;
      
      // legal values: 1-100
      // default: 90
      HUD_text_alpha = (float)Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Text Opacity", 90).getString()) / 100.0F;
      
      if(HUD_text_alpha < 0.0F || HUD_text_alpha > 1.0F)
	HUD_text_alpha = 0.9F;
      
      armour_HUD_config.save();
      
      
    
  }
  
  
  @EventHandler
  public void load(FMLInitializationEvent event)
  {
    try
    {
      Class.forName("ic2.core.IC2");
      log.info("IndustrialCraft 2 detected.");
    }
    catch(ClassNotFoundException e)
    {
      log.info("IndustrialCraft 2 not detected.");
      is_IC2_installed = false;
    }
    
    try
    {
      Class.forName("cofh.redstoneflux.api.IEnergyContainerItem");
      log.info("Thermal Expansion detected.");
    }
    catch(ClassNotFoundException e)
    {
      log.info("Thermal Expansion not detected.");
      is_TE_installed = false;
    }
    
    // UE appears to be defunct, seeing as how its website is now domain parked
    /*
    // use universalelectricity.api.energy.UnitDisplay to convert large numbers into SI prefixes
    // alternatively, could write my own SI prefix condenser function - this would be less dependent on UE
    try
    {
      Class.forName("universalelectricity.api.item.ItemElectric");
      log.info("Universal Electricity detected.");
    }
    catch(ClassNotFoundException e)
    {
      log.info("Universal Electricity not detected.");
      is_UE_installed = false;
    }
    */
    
    
    // LanguageRegistry.instance().addStringLocalization("ArmourHUD.HUD_position_button", "en_US", "Status HUD Location");
    // LanguageRegistry.instance().addStringLocalization("ArmourHUD.KeybindsCategory", "en_US", "Armour HUD");
    
    
    // registry stuff goes here at the end of Init
    // KeyBindingRegistry.registerKeyBinding(new ArmourHUD_KeyHandler());
    // TickRegistry.registerTickHandler(new ArmourHUD_ticker(mod_FruitLibs.getDisplayLib()), Side.CLIENT);
    
    // tick and key events are done through FMLCommonHandler, all else are through MinecraftForge.EVENT_BUS
    FMLCommonHandler.instance().bus().register(new ArmourHUD_KeyHandler());
    FMLCommonHandler.instance().bus().register(new ArmourHUD_ticker(mod_FruitLibs.getDisplayLib()));
    
  }
  
  public static String loadAbbreviatedItemName(String item_name)
  {
    // I take it forge derps when encountering non-alphanumeric/whitespace characters?
    for(int i = 0; i < item_name.length(); i++)
    {
      if((!Character.isLetterOrDigit(item_name.charAt(i)) && !Character.isWhitespace(item_name.charAt(i))) || item_name.charAt(i) > 255)
      {
	// it won't give a name for unicode objects
	// but it won't crash either...
	return item_name;
      }
    }
    // If name is null, attempt to pull configured name out of config. Otherwise supply hardcoded string.
    if(item_name == null || item_name == "" || item_name.isEmpty())
    {
      return "Unknown";
    }
    // If name !null, load par norm.
    else
    {
      armour_HUD_config.load();
      String CATEGORY_ABBREVIATIONS = "abbreviations";
      String temp_item_abbreviation = armour_HUD_config.get(CATEGORY_ABBREVIATIONS, item_name, item_name).getString();
      armour_HUD_config.save();
      return temp_item_abbreviation;
    }
  }
  
  public static void cycleHUDPosition()
  {
    if(ArmourHUD.HUD_position == 0)
    {
      ArmourHUD.HUD_position = 1;
    }
    else if(ArmourHUD.HUD_position == 1)
    {
      ArmourHUD.HUD_position = 2;
    }
    else if(ArmourHUD.HUD_position == 2)
    {
      ArmourHUD.HUD_position = 3;
    }
    else if(ArmourHUD.HUD_position == 3)
    {
      ArmourHUD.HUD_position = 4;
    }
    else
    {
      ArmourHUD.HUD_position = 0;
    }
    
    armour_HUD_config.load();
    
    Property HUD_pos_prop = armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Position", 1);
    
    HUD_pos_prop.set(Integer.toString(ArmourHUD.HUD_position));
    armour_HUD_config.save();
  }
  
  
}
