/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.eumj;

import buildcraft.api.enums.EnumPowerStage;
import buildcraft.lib.client.model.ModelHolderVariable;
import buildcraft.lib.client.model.ModelItemSimple;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.node.value.ITickableNode;
import buildcraft.lib.expression.node.value.NodeVariableDouble;
import buildcraft.lib.expression.node.value.NodeVariableObject;
import buildcraft.lib.misc.ExpressionCompat;
import buildcraft.lib.misc.data.ModelVariableData;
import com.chocohead.eumj.util.IEngine;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="eu-mj_engine", value={Side.CLIENT})
public class MagicModelLoader {
    static final FunctionContext fnCtx = new FunctionContext("", new FunctionContext[]{ExpressionCompat.ENUM_POWER_STAGE, DefaultContexts.createWithAll()});
    static final NodeVariableDouble ENGINE_PROGRESS = fnCtx.putVariableDouble("progress");
    static final NodeVariableObject<EnumPowerStage> ENGINE_STAGE = fnCtx.putVariableObject("stage", EnumPowerStage.class);
    static final NodeVariableObject<EnumFacing> ENGINE_FACING = fnCtx.putVariableObject("direction", EnumFacing.class);

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelBake(ModelBakeEvent event) {
        MagicModelLoader.ENGINE_PROGRESS.value = 0.2;
        MagicModelLoader.ENGINE_STAGE.value = EnumPowerStage.GREEN;
        MagicModelLoader.ENGINE_FACING.value = EnumFacing.UP;
        IRegistry modelRegistry = event.getModelRegistry();
        ModelVariableData varData = new ModelVariableData();
        for (Engine engine : Engine.values()) {
            varData.setNodes(engine.createTickableNodes());
            varData.tick();
            varData.refresh();
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (MutableQuad quad : engine.getCutoutQuads()) {
                quads.add(quad.toBakedItem());
            }
            modelRegistry.func_82595_a((Object)engine.getItemLocation(), (Object)new ModelItemSimple(quads, ModelItemSimple.TRANSFORM_BLOCK, true));
        }
    }

    public static enum Engine {
        SLOW_ELECTRIC_ENGINE,
        REGULAR_ELECTRIC_ENGINE,
        FAST_ELECTRIC_ENGINE,
        QUICK_ELECTRIC_ENGINE,
        ADJUSTABLE_ELECTRIC_ENGINE;

        private final ModelHolderVariable model = new ModelHolderVariable("eu-mj_engine:models/block/" + this.name().toLowerCase(Locale.ENGLISH) + ".json", fnCtx);
        private final ModelResourceLocation item = new ModelResourceLocation(new ResourceLocation("eu-mj_engine", "models/item/" + this.name().toLowerCase(Locale.ENGLISH)), "inventory");

        @SideOnly(value=Side.CLIENT)
        public MutableQuad[] getEngineQuads(IEngine tile, float partialTicks) {
            MagicModelLoader.ENGINE_PROGRESS.value = tile.getProgressClient(partialTicks);
            MagicModelLoader.ENGINE_STAGE.value = tile.getPowerStage();
            MagicModelLoader.ENGINE_FACING.value = tile.getFacing();
            ModelVariableData modelData = tile.getModelData();
            if (modelData.hasNoNodes()) {
                modelData.setNodes(this.model.createTickableNodes());
            }
            modelData.refresh();
            return this.model.getCutoutQuads();
        }

        public ModelResourceLocation getItemLocation() {
            return this.item;
        }

        @SideOnly(value=Side.CLIENT)
        ITickableNode[] createTickableNodes() {
            return this.model.createTickableNodes();
        }

        @SideOnly(value=Side.CLIENT)
        MutableQuad[] getCutoutQuads() {
            return this.model.getCutoutQuads();
        }
    }
}

