/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.eumj.gui;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.BCLibSprites;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.config.GuiConfigManager;
import buildcraft.lib.gui.ledger.Ledger_Neptune;
import buildcraft.lib.misc.LocaleUtil;
import com.chocohead.eumj.util.IEngine;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LedgerIEngine
extends Ledger_Neptune {
    private static final int OVERLAY_COLOUR = -2855905;
    private static final int HEADER_COLOUR = -1980113;
    private static final int SUB_HEADER_COLOUR = -5591112;
    private static final int TEXT_COLOUR = -16777216;
    protected final IEngine engine;

    public LedgerIEngine(BuildCraftGui gui, IEngine engine) {
        super(gui, -2855905, true);
        this.engine = engine;
        this.title = "gui.power";
        this.appendText(LocaleUtil.localize((String)"gui.currentOutput") + ':', -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeMjFlow((long)engine.getActiveOutput()), -16777216);
        this.appendText(LocaleUtil.localize((String)"gui.stored") + ':', -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeMj((long)engine.getPower()), -16777216);
        this.appendText(LocaleUtil.localize((String)"gui.heat") + ':', -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeHeat((double)engine.getHeat()), -16777216);
        this.calculateMaxSize();
        this.setOpenProperty(GuiConfigManager.getOrAddBoolean((ResourceLocation)new ResourceLocation("buildcraftlib:engine"), (String)"ledger.power.is_open", (boolean)false));
    }

    public int getTitleColour() {
        return -1980113;
    }

    protected void drawIcon(double x, double y) {
        ISprite sprite;
        switch (this.engine.getPowerStage()) {
            case OVERHEAT: {
                sprite = BCLibSprites.ENGINE_OVERHEAT;
                break;
            }
            case RED: 
            case YELLOW: {
                sprite = BCLibSprites.ENGINE_WARM;
                break;
            }
            default: {
                sprite = this.engine.getActive() ? BCLibSprites.ENGINE_ACTIVE : BCLibSprites.ENGINE_INACTIVE;
            }
        }
        GuiIcon.draw((ISprite)sprite, (double)x, (double)y, (double)(x + 16.0), (double)(y + 16.0));
    }
}

