/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.eumj.te;

import buildcraft.api.enums.EnumPowerStage;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.MjAPI;
import buildcraft.lib.engine.EngineConnector;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.help.DummyHelpElement;
import buildcraft.lib.gui.help.ElementHelpInfo;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import com.chocohead.eumj.EngineMod;
import com.chocohead.eumj.gui.DynamicBridgeGUI;
import com.chocohead.eumj.gui.LedgerIEngine;
import com.chocohead.eumj.te.TileEntityEngine;
import ic2.api.upgrade.IUpgradableBlock;
import ic2.api.upgrade.UpgradableProperty;
import ic2.core.ContainerBase;
import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Energy;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotDischarge;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.network.GuiSynced;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityElectricEngine
extends TileEntityEngine
implements IUpgradableBlock {
    protected final int tier;
    protected final Energy energy;
    public final InvSlotDischarge slot;
    public final InvSlotUpgrade upgrade;
    @GuiSynced
    protected boolean engineActive = false;

    public TileEntityElectricEngine(int tier) {
        this.tier = tier;
        this.slot = new InvSlotDischarge((TileEntityInventory)this, InvSlot.Access.IO, tier, false, InvSlot.InvSide.ANY);
        this.energy = ((Energy)this.addComponent((TileEntityComponent)new Energy((TileEntityBlock)this, 100000.0, Collections.singleton(this.getFacing().func_176734_d()), Collections.emptySet(), tier))).addManagedSlot((InvSlot)this.slot);
        this.upgrade = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 1);
    }

    @Override
    protected IMjConnector createConnector() {
        return new EngineConnector(false);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy.setDirections(Collections.singleton(this.getFacing().func_176734_d()), this.energy.getSinkDirs());
    }

    protected void setFacing(EnumFacing facing) {
        assert (this.getFacing() != facing);
        super.setFacing(facing);
        assert (facing == this.getFacing());
        this.energy.setDirections(Collections.singleton(facing.func_176734_d()), this.energy.getSinkDirs());
    }

    protected void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            this.updateTier();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.updateTier();
        }
    }

    protected void updateTier() {
        int tier = this.upgrade.getTier(this.tier);
        this.energy.setSinkTier(tier);
        this.slot.setTier(tier);
    }

    @Override
    protected EnumPowerStage computePowerStage() {
        return EnumPowerStage.GREEN;
    }

    @Override
    protected abstract double getPistonSpeed();

    @Override
    protected void burn() {
        long output = this.getOutput();
        double input = EngineMod.Conversion.MJtoEU(output);
        if (this.energy.canUseEnergy(input) && this.redstone.hasRedstoneInput()) {
            this.engineActive = true;
            this.addPower(output);
            this.energy.useEnergy(input);
        } else {
            this.engineActive = false;
        }
    }

    protected abstract long getOutput();

    @Override
    protected long getMaxPower() {
        return 10000L * MjAPI.MJ;
    }

    @Override
    public long maxPowerExtracted() {
        return 1000L * MjAPI.MJ;
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
    }

    @SideOnly(value=Side.CLIENT)
    protected DynamicBridgeGUI<TileEntityElectricEngine> makeBridge(EntityPlayer player, GuiParser.GuiNode node, boolean isAdmin) {
        return new DynamicBridgeGUI<TileEntityElectricEngine>(this, player, node);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        final GuiParser.GuiNode node = GuiParser.parse((ITeBlock)this.teBlock);
        final DynamicBridgeGUI<TileEntityElectricEngine> gui = this.makeBridge(player, node, isAdmin);
        gui.addHelpLedger();
        gui.getWrappedGUI().shownElements.add(new LedgerIEngine(gui.getWrappedGUI(), this));
        gui.addElementProducer(new Consumer<Consumer<IGuiElement>>(){

            private IGuiArea makeArea(GuiParser.SlotNode node2) {
                return new GuiRectangle((double)node2.x, (double)node2.y, (double)node2.style.width, (double)node2.style.height).offset((IGuiPosition)gui.getWrappedGUI().rootElement);
            }

            private ElementHelpInfo makeHelp(String name) {
                return new ElementHelpInfo("eu-mj_engine.help." + name + ".title", 0xFF000000 | name.hashCode() >> 4, new String[]{"eu-mj_engine.help." + name});
            }

            private void findSlots(Consumer<IGuiElement> list, GuiParser.ParentNode node2) {
                for (GuiParser.Node rawNode : node2.getNodes()) {
                    switch (rawNode.getType()) {
                        case slot: {
                            GuiParser.SlotNode realNode = (GuiParser.SlotNode)rawNode;
                            ElementHelpInfo help = null;
                            switch (realNode.name) {
                                case "upgrade": {
                                    help = this.makeHelp("upgrade");
                                    break;
                                }
                                case "discharge": {
                                    help = this.makeHelp("battery");
                                }
                            }
                            if (help == null) break;
                            list.accept((IGuiElement)new DummyHelpElement(this.makeArea(realNode), help));
                            break;
                        }
                    }
                    if (!(rawNode instanceof GuiParser.ParentNode)) continue;
                    this.findSlots(list, (GuiParser.ParentNode)rawNode);
                }
            }

            @Override
            public void accept(Consumer<IGuiElement> list) {
                this.findSlots(list, (GuiParser.ParentNode)node);
            }
        });
        return gui;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public long getActiveOutput() {
        return this.engineActive ? this.getOutput() : 0L;
    }

    public double getEnergy() {
        return this.energy.getEnergy();
    }

    public boolean useEnergy(double amount) {
        return this.energy.useEnergy(amount);
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer);
    }
}

