/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.eumj;

import buildcraft.api.BCBlocks;
import buildcraft.api.BCItems;
import buildcraft.api.BCModules;
import buildcraft.api.blocks.CustomRotationHelper;
import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.mj.MjAPI;
import buildcraft.transport.BCTransportItems;
import com.chocohead.eumj.GuideThings;
import com.chocohead.eumj.item.ItemReaderMJ;
import com.chocohead.eumj.te.Engine_TEs;
import com.chocohead.eumj.te.TileEntityEngine;
import ic2.api.event.TeBlockFinalCallEvent;
import ic2.api.item.IC2Items;
import ic2.api.recipe.Recipes;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.ITeBlock;
import ic2.core.block.TeBlockRegistry;
import ic2.core.item.ItemIC2;
import ic2.core.util.StackUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="eu-mj_engine", name="EU-MJ Engine", dependencies="required-after:ic2;required-after:buildcraftenergy@[7.99.16,7.99.17];after:buildcrafttransport", version="2.3.0", acceptedMinecraftVersions="[1.12.2]")
public final class EngineMod {
    public static final String MODID = "eu-mj_engine";
    public static final CreativeTabs TAB = new CreativeTabs("EU-MJ Engine"){
        private ItemStack[] items;
        private int ticker;

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_151244_d() {
            if (++this.ticker >= 500) {
                this.ticker = 0;
            }
            if (this.items == null) {
                this.items = new ItemStack[5];
                for (int i = 0; i < Engine_TEs.VALUES.length; ++i) {
                    this.items[i] = engine.getItemStack((ITeBlock)Engine_TEs.VALUES[i]);
                }
            }
            assert (this.ticker / 100 < this.items.length);
            return this.items[this.ticker / 100];
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_78016_d() {
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public String func_78024_c() {
            return "eu-mj_engine.creative_tab";
        }
    };
    public static BlockTileEntity engine;
    public static ItemIC2 readerMJ;

    @Mod.EventHandler
    public void construction(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void register(TeBlockFinalCallEvent event) {
        TeBlockRegistry.addAll(Engine_TEs.class, (ResourceLocation)Engine_TEs.IDENTITY);
        TeBlockRegistry.addCreativeRegisterer((list, block, item, tab) -> {
            if (tab == TAB || tab == CreativeTabs.field_78027_g) {
                Arrays.stream(Engine_TEs.VALUES).filter(Engine_TEs::hasItem).forEach(type -> list.add((Object)block.getItemStack((ITeBlock)type)));
            }
        }, (ResourceLocation)Engine_TEs.IDENTITY);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.loadConfig(event.getSuggestedConfigurationFile());
        event.getModLog().info("Running with " + Conversion.MJperEU / (double)MjAPI.MJ + " MJ per EU or " + (double)MjAPI.MJ / Conversion.MJperEU + " EU per MJ");
        engine = TeBlockRegistry.get((ResourceLocation)Engine_TEs.IDENTITY);
        engine.func_149647_a(TAB);
        if (BCModules.TRANSPORT.isLoaded()) {
            readerMJ = new ItemReaderMJ();
        }
        if (event.getSide().isClient() && readerMJ != null) {
            readerMJ.registerModels(null);
        }
    }

    private void loadConfig(File file) {
        Configuration config = new Configuration(file);
        try {
            config.load();
            Conversion.MJperEU = (float)MjAPI.MJ * config.getFloat("MJperEU", "balance", 0.4f, 0.01f, 100.0f, "The number of MJ per EU");
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception loading config!", e);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Engine_TEs.buildDummies(event.getSide().isClient());
        if (BCBlocks.Core.ENGINE != null) {
            Recipes.advRecipes.addRecipe(engine.getItemStack((ITeBlock)Engine_TEs.slow_electric_engine), new Object[]{"B", "E", "C", Character.valueOf('B'), EngineMod.anyCharge(IC2Items.getItem((String)"re_battery")), Character.valueOf('E'), new ItemStack(BCBlocks.Core.ENGINE, 1, EnumEngineType.STONE.ordinal()), Character.valueOf('C'), IC2Items.getItem((String)"crafting", (String)"circuit")});
            Recipes.advRecipes.addRecipe(engine.getItemStack((ITeBlock)Engine_TEs.regular_electric_engine), new Object[]{"B", "E", "C", Character.valueOf('B'), EngineMod.anyCharge(IC2Items.getItem((String)"re_battery")), Character.valueOf('E'), new ItemStack(BCBlocks.Core.ENGINE, 1, EnumEngineType.IRON.ordinal()), Character.valueOf('C'), IC2Items.getItem((String)"crafting", (String)"circuit")});
            Recipes.advRecipes.addRecipe(engine.getItemStack((ITeBlock)Engine_TEs.fast_electric_engine), new Object[]{"BBB", "EPE", "CPC", Character.valueOf('B'), EngineMod.anyCharge(IC2Items.getItem((String)"advanced_re_battery")), Character.valueOf('E'), new ItemStack(BCBlocks.Core.ENGINE, 1, EnumEngineType.IRON.ordinal()), Character.valueOf('P'), IC2Items.getItem((String)"crafting", (String)"alloy"), Character.valueOf('C'), IC2Items.getItem((String)"crafting", (String)"circuit")});
            Recipes.advRecipes.addRecipe(engine.getItemStack((ITeBlock)Engine_TEs.quick_electric_engine), new Object[]{"BPB", "EEE", "CPC", Character.valueOf('B'), EngineMod.anyCharge(IC2Items.getItem((String)"energy_crystal")), Character.valueOf('E'), new ItemStack(BCBlocks.Core.ENGINE, 1, EnumEngineType.IRON.ordinal()), Character.valueOf('P'), IC2Items.getItem((String)"crafting", (String)"alloy"), Character.valueOf('C'), IC2Items.getItem((String)"crafting", (String)"advanced_circuit")});
            Recipes.advRecipes.addRecipe(engine.getItemStack((ITeBlock)Engine_TEs.adjustable_electric_engine), new Object[]{"BCB", "EEE", "MTM", Character.valueOf('B'), EngineMod.anyCharge(IC2Items.getItem((String)"lapotron_crystal")), Character.valueOf('E'), new ItemStack(BCBlocks.Core.ENGINE, 1, EnumEngineType.IRON.ordinal()), Character.valueOf('C'), IC2Items.getItem((String)"crafting", (String)"advanced_circuit"), Character.valueOf('M'), IC2Items.getItem((String)"resource", (String)"advanced_machine"), Character.valueOf('T'), IC2Items.getItem((String)"te", (String)"hv_transformer")});
        }
        if (readerMJ != null && BCItems.Core.GEAR_GOLD != null && BCTransportItems.pipePowerWood != null) {
            HashSet<ItemStack> pipes = new HashSet<ItemStack>();
            for (Item pipe : new Item[]{BCTransportItems.pipePowerCobble, BCTransportItems.pipePowerStone, BCTransportItems.pipePowerQuartz, BCTransportItems.pipePowerGold, BCTransportItems.pipePowerSandstone}) {
                if (pipe == null) continue;
                pipes.add(new ItemStack(pipe));
            }
            if (!pipes.isEmpty()) {
                Recipes.advRecipes.addRecipe(new ItemStack((Item)readerMJ), new Object[]{" D ", "PGP", "p p", Character.valueOf('D'), Items.field_151114_aO, Character.valueOf('G'), BCItems.Core.GEAR_GOLD, Character.valueOf('P'), pipes, Character.valueOf('p'), BCTransportItems.pipePowerWood});
            }
        }
        if (event.getSide().isClient()) {
            GuideThings.addLoaders();
            GuideThings.addTags();
        }
    }

    private static ItemStack anyCharge(ItemStack stack) {
        return StackUtil.copyWithWildCard((ItemStack)stack);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CustomRotationHelper.INSTANCE.registerHandler((Block)engine, (world, pos, state, side) -> {
            TileEntity te = world.func_175625_s(pos);
            return te instanceof TileEntityEngine && ((TileEntityEngine)te).trySpin(side.func_176734_d()) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        });
    }

    public static class Conversion {
        static double MJperEU = MjAPI.MJ * 2L / 5L;

        public static double MJtoEU(long microjoules) {
            return (double)microjoules / MJperEU;
        }

        public static long EUtoMJ(double EU) {
            return (long)(EU * MJperEU);
        }
    }
}

