/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.eumj.te;

import buildcraft.api.mj.MjAPI;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.help.DummyHelpElement;
import buildcraft.lib.gui.help.ElementHelpInfo;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import com.chocohead.eumj.EngineMod;
import com.chocohead.eumj.gui.DynamicBridgeGUI;
import com.chocohead.eumj.gui.TransparentDynamicBridgeGUI;
import com.chocohead.eumj.te.TileEntityElectricEngine;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.init.Localization;
import ic2.core.network.GuiSynced;
import ic2.core.network.NetworkManager;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityAdjustableElectricEngine
extends TileEntityElectricEngine
implements INetworkClientTileEntityEventListener {
    private static final Field X;
    private static final Field Y;
    private static final Field WIDTH;
    private static final Field HEIGHT;
    private static final Field EVENT;
    @GuiSynced
    protected long output = 10L;
    protected double pistonSpeed = 0.07;

    public TileEntityAdjustableElectricEngine() {
        super(4);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74772_a("output", this.output);
        nbt.func_74780_a("piston", this.pistonSpeed);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.output = nbt.func_74763_f("output");
        this.pistonSpeed = nbt.func_74769_h("piston");
    }

    @Override
    public List<String> getNetworkedFields() {
        List<String> out = super.getNetworkedFields();
        out.add("output");
        out.add("pistonSpeed");
        return out;
    }

    @Override
    protected double getPistonSpeed() {
        return this.pistonSpeed;
    }

    @Override
    protected long getOutput() {
        return this.output * MjAPI.MJ;
    }

    @Override
    public long maxPowerExtracted() {
        return 3000L * MjAPI.MJ;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected DynamicBridgeGUI<TileEntityElectricEngine> makeBridge(EntityPlayer player, final GuiParser.GuiNode node, boolean isAdmin) {
        final TransparentDynamicBridgeGUI<TileEntityElectricEngine> gui = new TransparentDynamicBridgeGUI<TileEntityElectricEngine>(this, player, node);
        gui.addElementProducer(new Consumer<Consumer<IGuiElement>>(){

            private IGuiArea makeArea(GuiParser.ButtonNode node2) {
                try {
                    return new GuiRectangle((double)X.getInt(node2), (double)Y.getInt(node2), (double)WIDTH.getInt(node2), (double)HEIGHT.getInt(node2)).offset((IGuiPosition)gui.getWrappedGUI().rootElement);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException("Error reflecting button node", e);
                }
            }

            private ElementHelpInfo makeHelp(int change) {
                return new ElementHelpInfo("eu-mj_engine.help.power_button.title", 0xFF000000 | 150 * change, new String[]{Localization.translate((String)"eu-mj_engine.help.power_button", (Object[])new Object[]{change})});
            }

            private void findButtons(Consumer<IGuiElement> list, GuiParser.ParentNode node2) {
                for (GuiParser.Node rawNode : node2.getNodes()) {
                    switch (rawNode.getType()) {
                        case button: {
                            GuiParser.ButtonNode realNode = (GuiParser.ButtonNode)rawNode;
                            ElementHelpInfo help = null;
                            try {
                                switch (EVENT.getInt(realNode) % 10) {
                                    case 0: {
                                        help = this.makeHelp(-100);
                                        break;
                                    }
                                    case 1: {
                                        help = this.makeHelp(-10);
                                        break;
                                    }
                                    case 2: {
                                        help = this.makeHelp(-1);
                                        break;
                                    }
                                    case 3: {
                                        help = this.makeHelp(1);
                                        break;
                                    }
                                    case 4: {
                                        help = this.makeHelp(10);
                                        break;
                                    }
                                    case 5: {
                                        help = this.makeHelp(100);
                                    }
                                }
                            }
                            catch (IllegalAccessException | IllegalArgumentException e) {
                                throw new RuntimeException("Error reflecting button node", e);
                            }
                            if (help == null) break;
                            list.accept((IGuiElement)new DummyHelpElement(this.makeArea(realNode), help));
                            break;
                        }
                    }
                    if (!(rawNode instanceof GuiParser.ParentNode)) continue;
                    this.findButtons(list, (GuiParser.ParentNode)rawNode);
                }
            }

            @Override
            public void accept(Consumer<IGuiElement> list) {
                this.findButtons(list, (GuiParser.ParentNode)node);
            }
        });
        return gui;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        block0 : switch (event / 10) {
            case 0: {
                switch (event % 10) {
                    case 0: {
                        this.changeProduction(-100);
                        break block0;
                    }
                    case 1: {
                        this.changeProduction(-10);
                        break block0;
                    }
                    case 2: {
                        this.changeProduction(-1);
                        break block0;
                    }
                    case 3: {
                        this.changeProduction(1);
                        break block0;
                    }
                    case 4: {
                        this.changeProduction(10);
                        break block0;
                    }
                    case 5: {
                        this.changeProduction(100);
                    }
                }
            }
        }
    }

    protected void changeProduction(int value) {
        this.output = Math.max(this.output + (long)value, 1L);
        this.pistonSpeed = Math.max(0.1f, 1.0f / ((float)(3000L / this.output) - 2.0f));
        ((NetworkManager)IC2.network.get(true)).updateTileEntityField((TileEntity)this, "pistonSpeed");
    }

    @SideOnly(value=Side.CLIENT)
    public String getCurrentOutput() {
        return Localization.translate((String)"eu-mj_engine.engines.adjustable_electric_engine.info", (Object[])new Object[]{EngineMod.Conversion.MJtoEU(this.getOutput()), this.output});
    }

    static {
        Field x = null;
        Field y = null;
        Field width = null;
        Field height = null;
        Field event = null;
        block14: for (Field field : GuiParser.ButtonNode.class.getDeclaredFields()) {
            field.setAccessible(true);
            switch (field.getName()) {
                case "x": {
                    x = field;
                    continue block14;
                }
                case "y": {
                    y = field;
                    continue block14;
                }
                case "width": {
                    width = field;
                    continue block14;
                }
                case "height": {
                    height = field;
                    continue block14;
                }
                case "eventID": {
                    event = field;
                }
            }
        }
        X = x;
        Y = y;
        WIDTH = width;
        HEIGHT = height;
        EVENT = event;
        assert (X != null);
        assert (Y != null);
        assert (WIDTH != null);
        assert (HEIGHT != null);
        assert (EVENT != null);
    }
}

