/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.eumj.te;

import buildcraft.api.enums.EnumPowerStage;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.lib.block.VanillaRotationHandlers;
import buildcraft.lib.misc.data.ModelVariableData;
import com.chocohead.eumj.util.IEngine;
import com.chocohead.eumj.util.VeryOrderedEnumMap;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Redstone;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.network.GuiSynced;
import ic2.core.network.NetworkManager;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityEngine
extends TileEntityInventory
implements IHasGui,
IEngine {
    private static final Map<EnumFacing, List<AxisAlignedBB>> AABBs = TileEntityEngine.makeAABBmap();
    protected final Redstone redstone;
    protected final IMjConnector mjConnector = this.createConnector();
    protected final MjCapabilityHelper mjCaps = new MjCapabilityHelper(this.mjConnector);
    protected final ModelVariableData modelData = new ModelVariableData();
    @GuiSynced
    protected double heat = 20.0;
    protected EnumPowerStage powerStage = EnumPowerStage.BLUE;
    @GuiSynced
    protected long power;
    protected Progress movement = Progress.START;
    protected float progress;
    @SideOnly(value=Side.CLIENT)
    protected float lastProgress;

    public TileEntityEngine() {
        this.redstone = (Redstone)this.addComponent((TileEntityComponent)new Redstone((TileEntityBlock)this));
    }

    private static Map<EnumFacing, List<AxisAlignedBB>> makeAABBmap() {
        EnumMap<EnumFacing, List<AxisAlignedBB>> out = new EnumMap<EnumFacing, List<AxisAlignedBB>>(EnumFacing.class);
        out.put(EnumFacing.DOWN, Arrays.asList(new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75)));
        out.put(EnumFacing.UP, Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.25, 0.5, 0.25, 0.75, 1.0, 0.75)));
        out.put(EnumFacing.NORTH, Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.5)));
        out.put(EnumFacing.SOUTH, Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5), new AxisAlignedBB(0.25, 0.25, 0.5, 0.75, 0.75, 1.0)));
        out.put(EnumFacing.WEST, Arrays.asList(new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.25, 0.25, 0.5, 0.75, 0.75)));
        out.put(EnumFacing.EAST, Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0), new AxisAlignedBB(0.5, 0.25, 0.25, 1.0, 0.75, 0.75)));
        return out;
    }

    protected abstract IMjConnector createConnector();

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("heat", this.heat);
        nbt.func_74772_a("power", this.power);
        nbt.func_74776_a("progress", this.progress);
        nbt.func_74774_a("movement", (byte)this.movement.ordinal());
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heat = nbt.func_74769_h("heat");
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74760_g("progress");
        this.movement = Progress.VALUES[nbt.func_74771_c("movement") % Progress.VALUES.length];
    }

    private boolean isFacingMJ(EnumFacing dir) {
        TileEntity neighbour = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
        if (neighbour == null) {
            return false;
        }
        IMjConnector other = (IMjConnector)neighbour.getCapability(MjAPI.CAP_CONNECTOR, dir.func_176734_d());
        if (other == null) {
            return false;
        }
        return this.mjConnector.canConnect(other) && other.canConnect(this.mjConnector);
    }

    protected EnumFacing spin(EnumFacing start) {
        assert (start != null);
        for (EnumFacing facing : VeryOrderedEnumMap.loopFrom(VanillaRotationHandlers.ROTATE_FACING, start)) {
            if (!this.isFacingMJ(facing)) continue;
            return facing;
        }
        return null;
    }

    public boolean trySpin(EnumFacing start) {
        EnumFacing spun = this.spin(start);
        if (spun != null && this.getFacing() != spun) {
            this.setFacing(spun);
            return true;
        }
        return false;
    }

    protected EnumFacing getPlacementFacing(EntityLivingBase placer, EnumFacing placerFacing) {
        EnumFacing spun = this.spin(super.getPlacementFacing(placer, placerFacing).func_176734_d());
        return spun != null ? spun : EnumFacing.UP;
    }

    public List<String> getNetworkedFields() {
        List out = super.getNetworkedFields();
        out.add("progress");
        out.add("powerStage");
        return out;
    }

    protected double getPowerLevel() {
        return (double)this.power / (double)this.getMaxPower();
    }

    protected abstract long getMaxPower();

    protected double getHeatLevel() {
        return (this.heat - 20.0) / 230.0;
    }

    protected void updateHeatLevel() {
        this.heat = 230.0 * this.getPowerLevel() + 20.0;
    }

    protected EnumPowerStage computePowerStage() {
        double heatLevel = this.getHeatLevel();
        if (heatLevel < 0.25) {
            return EnumPowerStage.BLUE;
        }
        if (heatLevel < 0.5) {
            return EnumPowerStage.GREEN;
        }
        if (heatLevel < 0.75) {
            return EnumPowerStage.YELLOW;
        }
        if (heatLevel < (double)0.85f) {
            return EnumPowerStage.RED;
        }
        return EnumPowerStage.OVERHEAT;
    }

    @Override
    public EnumPowerStage getPowerStage() {
        EnumPowerStage newStage;
        if (!this.field_145850_b.field_72995_K && this.powerStage != (newStage = this.computePowerStage())) {
            this.powerStage = newStage;
            ((NetworkManager)IC2.network.get(true)).updateTileEntityField((TileEntity)this, "powerStage");
        }
        return this.powerStage;
    }

    protected double getPistonSpeed() {
        if (!this.field_145850_b.field_72995_K) {
            return Math.max(0.16 * this.getHeatLevel(), 0.01);
        }
        switch (this.getPowerStage()) {
            case BLUE: {
                return 0.02;
            }
            case GREEN: {
                return 0.04;
            }
            case YELLOW: {
                return 0.08;
            }
            case RED: {
                return 0.16;
            }
        }
        return 0.0;
    }

    protected void engineUpdate() {
        if (!this.redstone.hasRedstoneInput() && this.power > 0L) {
            this.power = Math.max(this.power - 1L, 0L);
        }
    }

    protected boolean canMove() {
        return this.redstone.hasRedstoneInput();
    }

    public abstract long maxPowerExtracted();

    public IMjReceiver getReceiverToPower(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        IMjReceiver rec = (IMjReceiver)tile.getCapability(MjAPI.CAP_RECEIVER, side.func_176734_d());
        return rec != null && rec.canConnect(this.mjConnector) ? rec : null;
    }

    public void addPower(long microJoules) {
        this.power = Math.min(this.power + microJoules, this.getMaxPower());
        if (this.getPowerStage() == EnumPowerStage.OVERHEAT) {
            // empty if block
        }
    }

    public long extractPower(long min, long max, boolean doExtract) {
        long extracted;
        if (this.power < min) {
            return 0L;
        }
        long actualMax = Math.min(this.maxPowerExtracted(), max);
        if (actualMax < min) {
            return 0L;
        }
        if (this.power >= actualMax) {
            extracted = actualMax;
            if (doExtract) {
                this.power -= actualMax;
            }
        } else {
            extracted = this.power;
            if (doExtract) {
                this.power = 0L;
            }
        }
        return extracted;
    }

    protected long getPowerToExtract(boolean doExtract) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        if (tile == null) {
            return 0L;
        }
        if (tile.getClass() == this.getClass()) {
            TileEntityEngine other = (TileEntityEngine)tile;
            return other.getMaxPower() - this.power;
        }
        IMjReceiver receiver = this.getReceiverToPower(tile, this.getFacing());
        if (receiver == null) {
            return 0L;
        }
        return this.extractPower(0L, receiver.getPowerRequested(), doExtract);
    }

    protected void sendPower() {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        if (tile == null) {
            return;
        }
        if (this.getClass() == tile.getClass()) {
            TileEntityEngine other = (TileEntityEngine)tile;
            if (this.getFacing() == other.getFacing()) {
                other.power += this.extractPower(0L, this.power, true);
            }
        } else {
            long extracted;
            IMjReceiver receiver = this.getReceiverToPower(tile, this.getFacing());
            if (receiver != null && (extracted = this.getPowerToExtract(true)) > 0L) {
                long excess = receiver.receivePower(extracted, false);
                this.extractPower(extracted - excess, extracted - excess, true);
            }
        }
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        if (!this.redstone.hasRedstoneInput() && this.power > 0L) {
            this.power = Math.max(this.power - MjAPI.MJ, 0L);
        }
        this.updateHeatLevel();
        boolean overheat = this.getPowerStage() == EnumPowerStage.OVERHEAT;
        this.engineUpdate();
        if (this.movement.isMoving()) {
            this.progress = (float)((double)this.progress + this.getPistonSpeed());
            if ((double)this.progress > 0.5 && this.movement == Progress.IN) {
                this.movement = Progress.OUT;
                this.sendPower();
            } else if (this.progress >= 1.0f) {
                this.progress = 0.0f;
                this.movement = Progress.START;
            }
        } else if (this.canMove() && this.getPowerToExtract(false) > 0L) {
            this.movement = Progress.IN;
            this.setActive(true);
        } else {
            this.setActive(false);
        }
        if (!overheat) {
            this.burn();
        }
    }

    protected abstract void burn();

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (facing == this.getFacing()) {
            return this.mjCaps.hasCapability(capability, facing) || capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && super.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing == this.getFacing()) {
            Object out = this.mjCaps.getCapability(capability, facing);
            if (out != null) {
                return (T)out;
            }
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return null;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelVariableData getModelData() {
        return this.modelData;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public long getPower() {
        return this.power;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double getHeat() {
        return this.heat;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getProgressClient(float partialTicks) {
        float last = this.lastProgress;
        float now = this.progress;
        if ((double)last > 0.5 && (double)now < 0.5) {
            now += 1.0f;
        }
        return (last * (1.0f - partialTicks) + now * partialTicks) % 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
        super.updateEntityClient();
        this.lastProgress = this.progress;
        if (this.getActive()) {
            this.progress = (float)((double)this.progress + this.getPistonSpeed());
            if (this.progress >= 1.0f) {
                this.progress = 0.0f;
            }
        } else if (this.progress > 0.0f) {
            this.progress -= 0.01f;
        }
        this.modelData.tick();
    }

    protected List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return AABBs.get(this.getFacing());
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        return true;
    }

    protected SoundType getBlockSound(Entity entity) {
        return SoundType.field_185852_e;
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public static enum Progress {
        START,
        IN,
        OUT;

        static final Progress[] VALUES;

        public boolean isMoving() {
            return this != START;
        }

        static {
            VALUES = Progress.values();
        }
    }
}

