/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.puddle;

import ic2.api.event.LaserEvent;
import ic2.core.item.tool.EntityMiningLaser;
import ic2.core.util.ReflectionUtil;
import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
@Mod(modid="full_drop", name="Full Drop", version="1.0", dependencies="required-after:ic2@[2.8.107,);", acceptedMinecraftVersions="[1.12.2]")
public class FullDrop {
    private static final Field airTickField = ReflectionUtil.getField(EntityMiningLaser.class, (String[])new String[]{"ticksInAir"});

    @SubscribeEvent
    public static void onBlockHit(LaserEvent.LaserHitsBlockEvent event) {
        event.dropChance = 1.0f;
    }

    @SubscribeEvent
    public static void onEntityHit(LaserEvent.LaserHitsEntityEvent event) {
        if (event.hitEntity instanceof EntityItem) {
            Entity laser = event.lasershot;
            Vec3d oldPosition = new Vec3d(laser.field_70165_t, laser.field_70163_u, laser.field_70161_v);
            Vec3d newPosition = new Vec3d(laser.field_70165_t + laser.field_70159_w, laser.field_70163_u + laser.field_70181_x, laser.field_70161_v + laser.field_70179_y);
            World world = event.getWorld();
            RayTraceResult result = world.func_147447_a(oldPosition, newPosition, false, true, false);
            oldPosition = new Vec3d(laser.field_70165_t, laser.field_70163_u, laser.field_70161_v);
            newPosition = result != null ? new Vec3d(result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c) : new Vec3d(laser.field_70165_t + laser.field_70159_w, laser.field_70163_u + laser.field_70181_x, laser.field_70161_v + laser.field_70179_y);
            double distance = 0.0;
            Entity hitEntity = null;
            for (Entity entity : world.func_72839_b(laser, laser.func_174813_aQ().func_72321_a(laser.field_70159_w, laser.field_70181_x, laser.field_70179_y).func_186662_g(1.0))) {
                double newDistance;
                RayTraceResult intercept;
                if (!entity.func_70067_L() || entity == event.owner && FullDrop.canFryOwner(laser) || entity instanceof EntityItem || (intercept = entity.func_174813_aQ().func_186662_g(0.3).func_72327_a(oldPosition, newPosition)) == null || !((newDistance = oldPosition.func_72436_e(intercept.field_72307_f)) < distance) && distance != 0.0) continue;
                hitEntity = entity;
                distance = newDistance;
            }
            if (hitEntity != null) {
                event.hitEntity = hitEntity;
            } else {
                event.passThrough = true;
                event.setCanceled(true);
            }
        }
    }

    private static boolean canFryOwner(Entity laser) {
        try {
            return airTickField.getInt(laser) < 5;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Error reflecting ticksInAir", e);
        }
    }
}

